/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.relay;

import java.lang.reflect.Method;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class OracleJarUtils {
    private static final Logger LOG = Logger.getLogger(OracleJarUtils.class);

    public static DataSource createOracleDataSource(String uri) throws Exception {
        DataSource ds = null;
        try {
            Class oracleDataSourceClass = OracleJarUtils.loadClass("oracle.jdbc.pool.OracleDataSource");
            Object ods = oracleDataSourceClass.newInstance();
            ds = (DataSource)ods;
            Method setURLMethod = oracleDataSourceClass.getMethod("setURL", String.class);
            Method getConnectionPropertiesMethod = oracleDataSourceClass.getMethod("getConnectionProperties", new Class[0]);
            Method setConnectionPropertiesMethod = oracleDataSourceClass.getMethod("setConnectionProperties", Properties.class);
            setURLMethod.invoke(ods, uri);
            Properties prop = (Properties)getConnectionPropertiesMethod.invoke(ods, new Object[0]);
            if (prop == null) {
                prop = new Properties();
            }
            setConnectionPropertiesMethod.invoke(ods, prop);
        }
        catch (Exception e) {
            String errMsg = "Error trying to create an Oracle DataSource";
            LOG.error((Object)errMsg, (Throwable)e);
            throw e;
        }
        return ds;
    }

    public static Class loadClass(String className) throws Exception {
        try {
            Class<?> cName = OracleJarUtils.class.getClassLoader().loadClass(className);
            return cName;
        }
        catch (Exception e) {
            LOG.error((Object)("Error loading a class " + className + " from ojdbc jar"), (Throwable)e);
            throw e;
        }
    }
}

