/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.internal.math;

import com.lyncode.jtwig.functions.JtwigFunction;
import com.lyncode.jtwig.functions.annotations.JtwigFunctionDeclaration;
import com.lyncode.jtwig.functions.exceptions.FunctionException;
import com.lyncode.jtwig.functions.util.Requirements;
import org.hamcrest.Matcher;
import org.hamcrest.core.AnyOf;
import org.hamcrest.core.IsInstanceOf;

@JtwigFunctionDeclaration(name="round")
public class Round
implements JtwigFunction {
    @Override
    public Object execute(Object ... arguments) throws FunctionException {
        Requirements.requires(arguments).withNumberOfArguments(Requirements.between(1, 2)).withArgument(0, (Matcher<Object>)AnyOf.anyOf((Matcher)IsInstanceOf.instanceOf(Integer.class), (Matcher)IsInstanceOf.instanceOf(Double.class), (Matcher)IsInstanceOf.instanceOf(Float.class)));
        if (arguments[0] instanceof Integer) {
            return arguments[0];
        }
        arguments[0] = (Double)arguments[0];
        String strategy = "common";
        if (arguments.length == 2) {
            strategy = arguments[1].toString().toLowerCase();
        }
        switch (RoundStrategy.valueOf(strategy.toUpperCase())) {
            case CEIL: {
                return (int)Math.ceil((Double)arguments[0]);
            }
            case FLOOR: {
                return (int)Math.floor((Double)arguments[0]);
            }
        }
        return (int)Math.round((Double)arguments[0]);
    }

    public static enum RoundStrategy {
        COMMON,
        CEIL,
        FLOOR;

    }
}

