/*
 * Decompiled with CFR 0.152.
 */
package com.lyncode.jtwig.functions.internal.string;

import com.lyncode.jtwig.functions.JtwigFunction;
import com.lyncode.jtwig.functions.annotations.JtwigFunctionDeclaration;
import com.lyncode.jtwig.functions.exceptions.FunctionException;
import com.lyncode.jtwig.functions.util.Requirements;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

@JtwigFunctionDeclaration(name="url_encode")
public class UrlEncode
implements JtwigFunction {
    @Override
    public Object execute(Object ... arguments) throws FunctionException {
        Requirements.requires(arguments).withNumberOfArguments((Matcher<Integer>)CoreMatchers.equalTo((Object)1));
        if (arguments[0] == null) {
            return null;
        }
        try {
            if (arguments[0] instanceof Map) {
                return this.encodeMap((Map)arguments[0]);
            }
            return URLEncoder.encode(arguments[0].toString(), Charset.defaultCharset().displayName());
        }
        catch (UnsupportedEncodingException e) {
            throw new FunctionException(e);
        }
    }

    private String encodeMap(Map argument) throws FunctionException {
        ArrayList<String> pieces = new ArrayList<String>();
        for (Object key : argument.keySet()) {
            pieces.add(this.encode(key.toString()) + "=" + this.encode(argument.get(key).toString()));
        }
        return StringUtils.join(pieces, (String)"&");
    }

    private String encode(String value) throws FunctionException {
        try {
            return URLEncoder.encode(value, Charset.defaultCharset().displayName());
        }
        catch (UnsupportedEncodingException e) {
            throw new FunctionException(e);
        }
    }
}

