/*
 * Decompiled with CFR 0.152.
 */
package com.m6d.filecrush.crush;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

class Bucketer {
    private final int maxBuckets;
    private final long bucketSize;
    private final List<HasSize> items = new LinkedList<HasSize>();
    private long size;
    private String dir;
    private final boolean excludeSingleItemBuckets;
    private static final Comparator<HasSize> DESCENDING_SIZE = new Comparator<HasSize>(){

        @Override
        public int compare(HasSize o1, HasSize o2) {
            long l2;
            long l1 = o1.size();
            if (l1 < (l2 = o2.size())) {
                return 1;
            }
            if (l1 > l2) {
                return -1;
            }
            return 0;
        }
    };

    public Bucketer(int numBuckets, boolean excludeSingleItemBuckets) {
        this(numBuckets, 0L, excludeSingleItemBuckets);
    }

    public Bucketer(int maxBuckets, long bucketSize, boolean excludeSingleItemBuckets) {
        if (1 > maxBuckets) {
            throw new IllegalArgumentException("Must have at least one bucket: " + maxBuckets);
        }
        this.maxBuckets = maxBuckets;
        if (0L > bucketSize) {
            throw new IllegalArgumentException("Bucket size must be zero or positive: " + bucketSize);
        }
        this.bucketSize = bucketSize;
        this.excludeSingleItemBuckets = excludeSingleItemBuckets;
    }

    public List<Bucket> createBuckets() {
        if (null == this.dir) {
            throw new IllegalStateException("No directory set");
        }
        Collections.sort(this.items, DESCENDING_SIZE);
        LinkedList<Bucket> buckets = new LinkedList<Bucket>();
        for (long remaining = this.size; remaining > 0L && buckets.size() < this.maxBuckets; remaining -= this.bucketSize) {
            buckets.add(new Bucket(String.format("%s-%d", this.dir, buckets.size())));
        }
        int numBuckets = buckets.size();
        if (1 == numBuckets) {
            Bucket bucket = (Bucket)buckets.getFirst();
            for (HasSize file : this.items) {
                bucket.add(file);
            }
        } else {
            for (HasSize item : this.items) {
                ListIterator<Bucket> iterator = buckets.listIterator();
                Bucket bucket = (Bucket)iterator.next();
                bucket.add(item);
                iterator.remove();
                while (buckets.size() < numBuckets && iterator.hasNext()) {
                    Bucket other = (Bucket)iterator.next();
                    if (other.bytes <= bucket.bytes) continue;
                    iterator.previous();
                    iterator.add(bucket);
                }
                if (buckets.size() >= numBuckets) continue;
                buckets.add(bucket);
            }
        }
        if (this.excludeSingleItemBuckets) {
            Iterator iter = buckets.iterator();
            while (iter.hasNext()) {
                Bucket bucket = (Bucket)iter.next();
                if (bucket.contents.size() >= 2) continue;
                iter.remove();
            }
        }
        this.dir = null;
        this.items.clear();
        this.size = 0L;
        return buckets;
    }

    public void add(HasSize item) {
        if (null == this.dir) {
            throw new IllegalStateException("No directory set");
        }
        long itemSize = item.size();
        if (0L != itemSize) {
            this.items.add(item);
            this.size += itemSize;
        }
    }

    int count() {
        return this.items.size();
    }

    long size() {
        return this.size;
    }

    public void reset(String dir) {
        if (dir.equals("")) {
            throw new IllegalArgumentException("Directory is empty");
        }
        this.dir = dir;
        this.items.clear();
        this.size = 0L;
    }

    String dir() {
        return this.dir;
    }

    static interface HasSize {
        public String id();

        public long size();
    }

    public static class Bucket
    implements HasSize {
        private final List<String> contents;
        private final String name;
        private long bytes;

        public Bucket(String name) {
            this.name = name;
            this.contents = new LinkedList<String>();
        }

        public Bucket(String name, List<String> contents, long bytes) {
            this.contents = contents;
            this.name = name;
            this.bytes = bytes;
        }

        private void add(HasSize hasSize) {
            this.contents.add(hasSize.id());
            this.bytes += hasSize.size();
        }

        public List<String> contents() {
            return Collections.unmodifiableList(this.contents);
        }

        public String name() {
            return this.name;
        }

        public long bytes() {
            return this.bytes;
        }

        @Override
        public String id() {
            return this.name();
        }

        @Override
        public long size() {
            return this.bytes();
        }

        public String toString() {
            return String.format("%s[%s, %d, %s]", this.getClass().getSimpleName(), this.name, this.bytes, this.contents);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Bucket)) {
                return false;
            }
            Bucket other = (Bucket)obj;
            return this.name.equals(other.name) && this.bytes == other.bytes && this.contents.equals(other.contents);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

