/*
 * Decompiled with CFR 0.152.
 */
package com.m6d.filecrush.crush;

import com.m6d.filecrush.crush.Bucketer;
import com.m6d.filecrush.crush.CountersInputFormat;
import com.m6d.filecrush.crush.CountersMapper;
import com.m6d.filecrush.crush.CrushPartitioner;
import com.m6d.filecrush.crush.CrushReducer;
import com.m6d.filecrush.crush.FileStatusHasSize;
import com.m6d.filecrush.crush.MapperCounter;
import com.m6d.filecrush.crush.ReducerCounter;
import java.io.BufferedReader;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.MultipleInputs;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class Crush
extends Configured
implements Tool {
    private final Matcher pathMatcher = Pattern.compile("([a-z]+:(//[a-z0-9A-Z-]+(\\.[a-z0-9A-Z-]+)*(:[0-9]+)?)?)?(.+)").matcher("dummy");
    private Path srcDir;
    private Path outDir;
    private Mode mode;
    private Path dest;
    private Path tmpDir;
    private Path bucketFiles;
    private Path partitionMap;
    private Path counters;
    private long maxEligibleSize;
    private long dfsBlockSize;
    private int maxFileBlocks;
    private JobConf job;
    private FileSystem fs;
    private List<Matcher> matchers;
    private Matcher ignoredFiles;
    private Counters jobCounters;
    private String codecExtension;
    private Set<String> skippedFiles;
    private int nBuckets;
    private boolean excludeSingleFileDirs;
    private Verbosity console;
    private static final Log LOG = LogFactory.getLog(Crush.class);

    Options buildOptions() {
        Options options = new Options();
        OptionBuilder.withDescription((String)"Print this help message");
        OptionBuilder.withLongOpt((String)"help");
        Option option = OptionBuilder.create((String)"?");
        options.addOption(option);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"directory regex");
        OptionBuilder.withDescription((String)"Regular expression that matches a directory name. Used to match a directory with a correponding replacement string");
        OptionBuilder.withLongOpt((String)"regex");
        option = OptionBuilder.create();
        options.addOption(option);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ignore file regex");
        OptionBuilder.withDescription((String)"Regular expression to apply for filtering out crush candidate files.  Any files in the input crush directory matching this will be ignored");
        OptionBuilder.withLongOpt((String)"ignore-regex");
        option = OptionBuilder.create();
        options.addOption(option);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"replacement string");
        OptionBuilder.withDescription((String)"Replacement string used with the corresponding regex to calculate the name of a directory's crush output file");
        OptionBuilder.withLongOpt((String)"replacement");
        option = OptionBuilder.create();
        options.addOption(option);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"FQN input format");
        OptionBuilder.withDescription((String)"Input format used to open the files of directories matching the corresponding regex");
        OptionBuilder.withLongOpt((String)"input-format");
        option = OptionBuilder.create();
        options.addOption(option);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"FQN output format");
        OptionBuilder.withDescription((String)"Output format used to open the files of directories matching the corresponding regex");
        OptionBuilder.withLongOpt((String)"output-format");
        option = OptionBuilder.create();
        options.addOption(option);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"threshold");
        OptionBuilder.withDescription((String)"Threshold relative to the dfs block size over which a file becomes eligible for crushing. Must be in the range (0 and 1]. Default 0.75");
        OptionBuilder.withLongOpt((String)"threshold");
        option = OptionBuilder.create();
        options.addOption(option);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"max-file-blocks");
        OptionBuilder.withDescription((String)"The maximum number of dfs blocks per output file. Input files are grouped into output files under the assumption that the input and output compression codecs have comparable efficiency. Default is 8.");
        OptionBuilder.withLongOpt((String)"max-file-blocks");
        option = OptionBuilder.create();
        options.addOption(option);
        OptionBuilder.withDescription((String)"Do not skip directories containing single files.");
        OptionBuilder.withLongOpt((String)"include-single-file-dirs");
        option = OptionBuilder.create();
        options.addOption(option);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"compression codec");
        OptionBuilder.withDescription((String)"FQN of the compression codec to use or \"none\". Defaults to DefaultCodec.");
        OptionBuilder.withLongOpt((String)"compress");
        option = OptionBuilder.create();
        options.addOption(option);
        OptionBuilder.withDescription((String)"Operate in clone mode.");
        OptionBuilder.withLongOpt((String)"clone");
        option = OptionBuilder.create();
        options.addOption(option);
        OptionBuilder.withDescription((String)"Info logging to console.");
        OptionBuilder.withLongOpt((String)"info");
        option = OptionBuilder.create();
        options.addOption(option);
        OptionBuilder.withDescription((String)"Verbose logging to console.");
        OptionBuilder.withLongOpt((String)"verbose");
        option = OptionBuilder.create();
        options.addOption(option);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean createJobConfAndParseArgs(String ... args) throws ParseException, IOException {
        String crushTimestamp;
        this.job = new JobConf(this.getConf(), Crush.class);
        this.job.setMapSpeculativeExecution(false);
        this.job.setReduceSpeculativeExecution(false);
        this.job.set("mapred.fairscheduler.preemption", "false");
        this.tmpDir = new Path("tmp/crush-" + UUID.randomUUID());
        this.outDir = new Path(this.tmpDir, "out");
        double threshold = 0.75;
        List<String> regexes = Arrays.asList(".+");
        List<String> replacements = Arrays.asList("crushed_file-${crush.timestamp}-${crush.task.num}-${crush.file.num}");
        List<String> inFormats = Arrays.asList(SequenceFileInputFormat.class.getName());
        List<String> outFormats = Arrays.asList(SequenceFileOutputFormat.class.getName());
        Options options = this.buildOptions();
        CommandLine cli = new GnuParser().parse(options, args);
        if (cli.hasOption("?")) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("help.txt")));
            try {
                String line;
                while (null != (line = reader.readLine())) {
                    System.out.println(line);
                }
            }
            finally {
                reader.close();
            }
            return false;
        }
        this.console = cli.hasOption("verbose") ? Verbosity.VERBOSE : (cli.hasOption("info") ? Verbosity.INFO : Verbosity.NONE);
        if (cli.hasOption("ignore-regex")) {
            this.ignoredFiles = Pattern.compile(cli.getOptionValue("ignore-regex")).matcher("");
        }
        this.excludeSingleFileDirs = !cli.hasOption("include-single-file-dirs");
        String[] nonOptions = cli.getArgs();
        if (2 == nonOptions.length) {
            this.mode = Mode.STAND_ALONE;
            this.srcDir = new Path(nonOptions[0]);
            this.dest = new Path(nonOptions[1]);
            if (cli.hasOption("input-format")) {
                inFormats = Arrays.asList(cli.getOptionValue("input-format"));
            }
            if (cli.hasOption("output-format")) {
                outFormats = Arrays.asList(cli.getOptionValue("output-format"));
            }
            replacements = Arrays.asList(this.dest.getName());
            crushTimestamp = Long.toString(System.currentTimeMillis());
        } else {
            if ((args.length == 4 || args.length == 3) && args.length == nonOptions.length && args[2].length() != 14) {
                int maxTasks = Integer.parseInt(args[2]);
                if (maxTasks <= 0 || maxTasks > 4000) {
                    throw new IllegalArgumentException("Tasks must be in the range [1, 4000]: " + maxTasks);
                }
                this.job.setInt("mapred.reduce.tasks", maxTasks);
                this.maxFileBlocks = Integer.MAX_VALUE;
                crushTimestamp = Long.toString(System.currentTimeMillis());
                this.srcDir = new Path(args[0]);
                this.dest = new Path(args[1]);
                this.mode = Mode.CLONE;
                if (args.length == 4) {
                    if (args[3].equals("TEXT")) {
                        inFormats = Arrays.asList(TextInputFormat.class.getName());
                        outFormats = Arrays.asList(TextOutputFormat.class.getName());
                    } else if (!args[3].equals("SEQUENCE")) {
                        throw new IllegalArgumentException("Type must be either TEXT or SEQUENCE: " + args[3]);
                    }
                }
            } else {
                if (cli.hasOption("threshold") && (0.0 >= (threshold = Double.parseDouble(cli.getOptionValue("threshold"))) || 1.0 < threshold || Double.isInfinite(threshold) || Double.isNaN(threshold))) {
                    throw new IllegalArgumentException("Block size threshold must be in (0, 1]: " + threshold);
                }
                if (cli.hasOption("max-file-blocks")) {
                    int maxFileBlocksOption = Integer.parseInt(cli.getOptionValue("max-file-blocks"));
                    if (0 > maxFileBlocksOption) {
                        throw new IllegalArgumentException("Maximum file size in blocks must be positive: " + maxFileBlocksOption);
                    }
                    this.maxFileBlocks = maxFileBlocksOption;
                } else {
                    this.maxFileBlocks = 8;
                }
                if (cli.hasOption("regex")) {
                    regexes = Arrays.asList(cli.getOptionValues("regex"));
                }
                if (cli.hasOption("replacement")) {
                    replacements = Arrays.asList(cli.getOptionValues("replacement"));
                }
                if (cli.hasOption("input-format")) {
                    inFormats = Arrays.asList(cli.getOptionValues("input-format"));
                }
                if (cli.hasOption("output-format")) {
                    outFormats = Arrays.asList(cli.getOptionValues("output-format"));
                }
                if (3 != nonOptions.length) {
                    throw new IllegalArgumentException("Could not find source directory, out directory, and job timestamp");
                }
                this.srcDir = new Path(nonOptions[0]);
                this.dest = new Path(nonOptions[1]);
                crushTimestamp = nonOptions[2];
                this.mode = cli.hasOption("clone") ? Mode.CLONE : Mode.MAP_REDUCE;
                if (!crushTimestamp.matches("\\d{14}")) {
                    throw new IllegalArgumentException("Crush timestamp must be 14 digits yyyymmddhhMMss: " + crushTimestamp);
                }
            }
            this.dfsBlockSize = this.parseDfsBlockSize(this.job);
            this.maxEligibleSize = (long)((double)this.dfsBlockSize * threshold);
        }
        this.job.set("crush.timestamp", crushTimestamp);
        if (this.ignoredFiles != null) {
            this.job.set("crush.ignore-regex", this.ignoredFiles.pattern().pattern());
        }
        if (regexes.size() != replacements.size() || replacements.size() != inFormats.size() || inFormats.size() != outFormats.size()) {
            throw new IllegalArgumentException("Must be an equal number of regex, replacement, in-format, and out-format options");
        }
        this.job.setInt("crush.num.specs", regexes.size());
        this.matchers = new ArrayList<Matcher>(regexes.size());
        for (int i = 0; i < regexes.size(); ++i) {
            this.job.set(String.format("crush.%d.regex", i), regexes.get(i));
            this.matchers.add(Pattern.compile(regexes.get(i)).matcher("dummy"));
            this.job.set(String.format("crush.%d.regex.replacement", i), replacements.get(i));
            String inFmt = inFormats.get(i);
            if ("sequence".equals(inFmt)) {
                inFmt = SequenceFileInputFormat.class.getName();
            } else if ("text".equals(inFmt)) {
                inFmt = TextInputFormat.class.getName();
            } else {
                try {
                    if (!FileInputFormat.class.isAssignableFrom(Class.forName(inFmt))) {
                        throw new IllegalArgumentException("Not a FileInputFormat:" + inFmt);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Not a FileInputFormat:" + inFmt);
                }
            }
            this.job.set(String.format("crush.%d.input.format", i), inFmt);
            String outFmt = outFormats.get(i);
            if ("sequence".equals(outFmt)) {
                outFmt = SequenceFileOutputFormat.class.getName();
            } else if ("text".equals(outFmt)) {
                outFmt = TextOutputFormat.class.getName();
            } else {
                try {
                    if (!FileOutputFormat.class.isAssignableFrom(Class.forName(outFmt))) {
                        throw new IllegalArgumentException("Not a FileOutputFormat:" + outFmt);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Not a FileOutputFormat:" + outFmt);
                }
            }
            this.job.set(String.format("crush.%d.output.format", i), outFmt);
        }
        String codec = cli.getOptionValue("compress");
        if (null == codec) {
            codec = DefaultCodec.class.getName();
        } else if ("none".equals(codec)) {
            codec = null;
        } else if ("gzip".equals(codec)) {
            codec = GzipCodec.class.getName();
        } else {
            try {
                if (!CompressionCodec.class.isAssignableFrom(Class.forName(codec))) {
                    throw new IllegalArgumentException("Not a CompressionCodec: " + codec);
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Not a CompressionCodec: " + codec);
            }
        }
        if (null == codec) {
            this.job.setBoolean("mapred.output.compress", false);
        } else {
            this.job.setBoolean("mapred.output.compress", true);
            this.job.set("mapred.output.compression.type", "BLOCK");
            this.job.set("mapred.output.compression.codec", codec);
            try {
                CompressionCodec instance = (CompressionCodec)Class.forName(codec).newInstance();
                this.codecExtension = instance.getDefaultExtension();
            }
            catch (Exception e) {
                throw new AssertionError();
            }
        }
        return true;
    }

    private long parseDfsBlockSize(JobConf job) {
        long old = job.getLong("dfs.block.size", -1L);
        if (old == -1L) {
            old = job.getLong("dfs.blocksize", -1L);
        }
        if (old == -1L) {
            throw new RuntimeException("Could not determine how to set block size. Abandon ship!");
        }
        return old;
    }

    public int run(String[] args) throws Exception {
        if (!this.createJobConfAndParseArgs(args)) {
            return 0;
        }
        this.setFileSystem(FileSystem.get((Configuration)this.job));
        FileStatus status = this.fs.getFileStatus(this.srcDir);
        if (null == status || !status.isDir()) {
            throw new IllegalArgumentException("No such directory: " + this.srcDir);
        }
        if (Mode.STAND_ALONE == this.mode) {
            this.standAlone();
        } else {
            long crushed;
            long eligible;
            this.writeDirs();
            MultipleInputs.addInputPath((JobConf)this.job, (Path)this.bucketFiles, SequenceFileInputFormat.class, IdentityMapper.class);
            MultipleInputs.addInputPath((JobConf)this.job, (Path)this.counters, CountersInputFormat.class, CountersMapper.class);
            this.job.setPartitionerClass(CrushPartitioner.class);
            this.job.setReducerClass(CrushReducer.class);
            this.job.setOutputKeyComparatorClass(Text.Comparator.class);
            this.job.setOutputKeyClass(Text.class);
            this.job.setOutputValueClass(Text.class);
            this.job.setOutputFormat(SequenceFileOutputFormat.class);
            FileInputFormat.setInputPaths((JobConf)this.job, (Path[])new Path[]{this.bucketFiles});
            FileOutputFormat.setOutputPath((JobConf)this.job, (Path)this.outDir);
            this.job.set("crush.partition.map", this.partitionMap.toString());
            if (0 != this.nBuckets) {
                this.print(Verbosity.INFO, "\n\nInvoking map reduce\n\n");
                RunningJob completed = JobClient.runJob((JobConf)this.job);
                this.jobCounters = completed.getCounters();
            }
            if ((eligible = this.jobCounters.getCounter((Enum)MapperCounter.FILES_ELIGIBLE)) != (crushed = this.jobCounters.getCounter((Enum)ReducerCounter.FILES_CRUSHED))) {
                throw new AssertionError((Object)String.format("Files eligible (%d) != files crushed (%d)", eligible, crushed));
            }
            if (Mode.CLONE == this.mode) {
                this.cloneOutput();
            } else {
                this.moveOutput();
            }
        }
        this.print(Verbosity.INFO, "\n\nDeleting temporary directory");
        this.fs.delete(this.tmpDir, true);
        this.print(Verbosity.INFO, "\n\n");
        return 0;
    }

    private void standAlone() throws IOException {
        FileStatus[] contents;
        String absSrcDir = this.fs.makeQualified(this.srcDir).toUri().getPath();
        String absOutDir = this.fs.makeQualified(this.outDir).toUri().getPath();
        Text bucket = new Text(absSrcDir + "-0");
        ArrayList<Text> files = new ArrayList<Text>();
        for (FileStatus content : contents = this.fs.listStatus(new Path(absSrcDir))) {
            if (content.isDir()) continue;
            if (this.ignoredFiles != null) {
                this.ignoredFiles.reset(content.getPath().toUri().getPath());
                if (this.ignoredFiles.matches()) {
                    LOG.trace((Object)("Ignoring " + content.getPath().toString()));
                    continue;
                }
            }
            files.add(new Text(content.getPath().toUri().getPath()));
        }
        if (files.isEmpty()) {
            return;
        }
        this.job.set("mapred.tip.id", "task_000000000000_00000_r_000000");
        this.job.set("mapred.task.id", "attempt_000000000000_0000_r_000000_0");
        this.job.set("mapred.output.dir", absOutDir);
        this.fs.mkdirs(new Path(absOutDir, "_temporary"));
        CrushReducer reducer = new CrushReducer();
        reducer.configure(this.job);
        reducer.reduce(bucket, files.iterator(), new NullOutputCollector<Text, Text>(), Reporter.NULL);
        reducer.close();
        Path crushOutput = new Path(absOutDir + "/*/*/crush" + absSrcDir + "/" + this.dest.getName() + "*");
        FileStatus[] statuses = this.fs.globStatus(crushOutput);
        if (statuses == null || 1 != statuses.length) {
            throw new AssertionError((Object)("Did not find the expected output in " + crushOutput.toString()));
        }
        this.rename(statuses[0].getPath(), this.dest.getParent(), this.dest.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cloneOutput() throws IOException {
        List<FileStatus> listStatus = this.getOutputMappings();
        List<Path> crushInput = Collections.emptyList();
        Text srcFile = new Text();
        Text crushOut = new Text();
        Text prevCrushOut = new Text();
        for (FileStatus partFile : listStatus) {
            Path path = partFile.getPath();
            SequenceFile.Reader reader = new SequenceFile.Reader(this.fs, path, this.fs.getConf());
            try {
                while (reader.next((Writable)srcFile, (Writable)crushOut)) {
                    if (!crushOut.equals((Object)prevCrushOut)) {
                        this.swap(crushInput, prevCrushOut.toString());
                        prevCrushOut.set(crushOut);
                        crushInput = new LinkedList<Path>();
                    }
                    crushInput.add(new Path(srcFile.toString()));
                }
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Trapped exception when closing " + path), (Throwable)e);
                }
            }
            this.swap(crushInput, prevCrushOut.toString());
        }
    }

    private List<FileStatus> getOutputMappings() throws IOException {
        FileStatus[] files = this.fs.listStatus(this.outDir, new PathFilter(){
            Matcher matcher = Pattern.compile("part-\\d+").matcher("dummy");

            public boolean accept(Path path) {
                this.matcher.reset(path.getName());
                return this.matcher.matches();
            }
        });
        return Arrays.asList(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveOutput() throws IOException {
        Path destPath;
        Path srcPath;
        List<FileStatus> listStatus = this.getOutputMappings();
        Text srcFile = new Text();
        Text crushOut = new Text();
        HashSet<String> crushOutputFiles = new HashSet<String>(this.nBuckets);
        for (FileStatus partFile : listStatus) {
            Path path = partFile.getPath();
            SequenceFile.Reader reader = new SequenceFile.Reader(this.fs, path, this.fs.getConf());
            try {
                while (reader.next((Writable)srcFile, (Writable)crushOut)) {
                    crushOutputFiles.add(new Path(crushOut.toString()).toUri().getPath());
                }
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Trapped exception when closing " + path), (Throwable)e);
                }
            }
        }
        assert (crushOutputFiles.size() == this.nBuckets);
        String srcDirName = this.fs.makeQualified(this.srcDir).toUri().getPath();
        String destName = this.fs.makeQualified(this.dest).toUri().getPath();
        String partToReplace = this.fs.makeQualified(this.outDir).toUri().getPath() + "/crush" + srcDirName;
        this.print(Verbosity.INFO, "\n\nCopying crush files to " + destName);
        for (String crushOutputFile : crushOutputFiles) {
            srcPath = new Path(crushOutputFile);
            destPath = new Path(destName + crushOutputFile.substring(partToReplace.length())).getParent();
            this.rename(srcPath, destPath, null);
        }
        this.print(Verbosity.INFO, "\n\nMoving skipped files to " + destName);
        for (String name : this.skippedFiles) {
            srcPath = new Path(name);
            destPath = new Path(destName + name.substring(srcDirName.length())).getParent();
            this.rename(srcPath, destPath, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swap(List<Path> crushInput, String crushFileName) throws IOException {
        block11: {
            boolean crushFileNotInstalled;
            Path crushedDir;
            block10: {
                if (crushInput.isEmpty()) {
                    return;
                }
                this.print(Verbosity.INFO, String.format("\n\nSwapping %s", crushFileName));
                ArrayList<Path> movedSrc = new ArrayList<Path>(crushInput.size());
                ArrayList<Path> movedDest = new ArrayList<Path>(crushInput.size());
                crushedDir = crushInput.get(0).getParent();
                crushFileNotInstalled = true;
                try {
                    Iterator<Path> iter = crushInput.iterator();
                    while (iter.hasNext()) {
                        Path source = iter.next();
                        Path destPath = new Path(this.dest, source.toString().substring(1));
                        this.rename(source, destPath.getParent(), null);
                        iter.remove();
                        movedSrc.add(source);
                        movedDest.add(destPath);
                    }
                    Path crushFile = new Path(crushFileName);
                    this.rename(crushFile, crushedDir, null);
                    crushFileNotInstalled = false;
                    if (crushInput.isEmpty()) break block10;
                }
                catch (Throwable throwable) {
                    if (!crushInput.isEmpty()) {
                        LOG.error((Object)String.format("Failed while moving files into the clone directory and before installing the crush output file (%d moved and %d remaining)", movedSrc.size(), crushInput.size()));
                        StringBuilder sb = new StringBuilder("hadoop fs -mv ");
                        for (int i = 0; i < movedSrc.size(); ++i) {
                            sb.append(" ");
                            sb.append(movedDest.get(i));
                        }
                        sb.append(" ");
                        sb.append(crushedDir);
                        LOG.error((Object)("Execute the following to restore the file system to a good state: " + sb.toString()));
                    } else if (crushFileNotInstalled) {
                        LOG.error((Object)String.format("Failed while moving crush output file (%s) to the source directory (%s)", crushFileName, crushedDir));
                    }
                    throw throwable;
                }
                LOG.error((Object)String.format("Failed while moving files into the clone directory and before installing the crush output file (%d moved and %d remaining)", movedSrc.size(), crushInput.size()));
                StringBuilder sb = new StringBuilder("hadoop fs -mv ");
                for (int i = 0; i < movedSrc.size(); ++i) {
                    sb.append(" ");
                    sb.append(movedDest.get(i));
                }
                sb.append(" ");
                sb.append(crushedDir);
                LOG.error((Object)("Execute the following to restore the file system to a good state: " + sb.toString()));
                break block11;
            }
            if (crushFileNotInstalled) {
                LOG.error((Object)String.format("Failed while moving crush output file (%s) to the source directory (%s)", crushFileName, crushedDir));
            }
        }
    }

    private void rename(Path src, Path destDir, String fileName) throws IOException {
        this.fs.mkdirs(destDir);
        if (null != this.codecExtension && !this.fs.exists(src)) {
            src = new Path(src + this.codecExtension);
        }
        Path dest = null == fileName ? new Path(destDir, src.getName()) : new Path(destDir, fileName);
        this.fs.rename(src, dest);
        this.print(Verbosity.VERBOSE, String.format("\n  %s => %s", src, dest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeDirs() throws IOException {
        this.print(Verbosity.INFO, "\n\nUsing temporary directory " + this.tmpDir.toUri().getPath());
        FileStatus status = this.fs.getFileStatus(this.srcDir);
        Path tmpIn = new Path(this.tmpDir, "in");
        this.bucketFiles = new Path(tmpIn, "dirs");
        this.partitionMap = new Path(tmpIn, "partition-map");
        this.counters = new Path(tmpIn, "counters");
        this.skippedFiles = new HashSet<String>();
        List<Path> dirs = Arrays.asList(status.getPath());
        Text key = new Text();
        Text value = new Text();
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)this.fs, (Configuration)this.job, (Path)this.bucketFiles, Text.class, Text.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
        int numPartitions = Integer.parseInt(this.job.get("mapred.reduce.tasks"));
        Bucketer partitionBucketer = new Bucketer(numPartitions, 0L, false);
        partitionBucketer.reset("partition-map");
        this.jobCounters = new Counters();
        try {
            while (!dirs.isEmpty()) {
                LinkedList<Path> nextLevel = new LinkedList<Path>();
                for (Path path : dirs) {
                    this.jobCounters.incrCounter((Enum)MapperCounter.DIRS_FOUND, 1L);
                    this.print(Verbosity.INFO, "\n\n" + path.toUri().getPath());
                    FileStatus[] contents = this.fs.listStatus(path, new PathFilter(){

                        public boolean accept(Path testPath) {
                            if (Crush.this.ignoredFiles == null) {
                                return true;
                            }
                            Crush.this.ignoredFiles.reset(testPath.toUri().getPath());
                            return !Crush.this.ignoredFiles.matches();
                        }
                    });
                    if (contents == null || contents.length == 0) {
                        this.print(Verbosity.INFO, " is empty");
                        this.jobCounters.incrCounter((Enum)MapperCounter.DIRS_SKIPPED, 1L);
                        continue;
                    }
                    ArrayList<FileStatus> crushables = new ArrayList<FileStatus>(contents.length);
                    HashSet<String> uncrushedFiles = new HashSet<String>(contents.length);
                    long crushableBytes = 0L;
                    for (FileStatus content : contents) {
                        Path path2 = content.getPath();
                        if (content.isDir()) {
                            nextLevel.add(path2);
                            continue;
                        }
                        boolean changed = uncrushedFiles.add(path2.toUri().getPath());
                        assert (changed) : path2.toUri().getPath();
                        long fileLength = content.getLen();
                        if (fileLength > this.maxEligibleSize) continue;
                        crushables.add(content);
                        crushableBytes += fileLength;
                    }
                    if (!uncrushedFiles.isEmpty()) {
                        if (-1 == this.findMatcher(path)) {
                            throw new IllegalArgumentException("Could not find matching regex for directory: " + path);
                        }
                        this.jobCounters.incrCounter((Enum)MapperCounter.FILES_FOUND, (long)uncrushedFiles.size());
                    }
                    if (0L == crushableBytes) {
                        this.print(Verbosity.INFO, " has no crushable files");
                        this.jobCounters.incrCounter((Enum)MapperCounter.DIRS_SKIPPED, 1L);
                    } else {
                        long dirBuckets;
                        long nBlocks = crushableBytes / this.dfsBlockSize;
                        if (nBlocks * this.dfsBlockSize != crushableBytes) {
                            ++nBlocks;
                        }
                        if ((dirBuckets = nBlocks / (long)this.maxFileBlocks) * (long)this.maxFileBlocks != nBlocks) {
                            ++dirBuckets;
                        }
                        if (dirBuckets > Integer.MAX_VALUE) {
                            throw new AssertionError((Object)("Too many buckets: " + dirBuckets));
                        }
                        Bucketer directoryBucketer = new Bucketer((int)dirBuckets, this.excludeSingleFileDirs);
                        directoryBucketer.reset(this.getPathPart(path));
                        for (FileStatus file : crushables) {
                            directoryBucketer.add(new FileStatusHasSize(file));
                        }
                        List<Bucketer.Bucket> crushFiles = directoryBucketer.createBuckets();
                        if (crushFiles.isEmpty()) {
                            this.jobCounters.incrCounter((Enum)MapperCounter.DIRS_SKIPPED, 1L);
                        } else {
                            this.nBuckets += crushFiles.size();
                            this.jobCounters.incrCounter((Enum)MapperCounter.DIRS_ELIGIBLE, 1L);
                            this.print(Verbosity.INFO, " => " + crushFiles.size() + " output files");
                            for (Bucketer.Bucket crushFile : crushFiles) {
                                String bucketId = crushFile.name();
                                List<String> bucketFiles = crushFile.contents();
                                this.print(Verbosity.INFO, String.format("\n  Output %s will include %,d input bytes from %,d files", bucketId, crushFile.size(), bucketFiles.size()));
                                key.set(bucketId);
                                for (String f : bucketFiles) {
                                    boolean changed = uncrushedFiles.remove(f);
                                    assert (changed) : f;
                                    this.pathMatcher.reset(f);
                                    this.pathMatcher.matches();
                                    value.set(this.pathMatcher.group(5));
                                    writer.append((Writable)key, (Writable)value);
                                    this.print(Verbosity.VERBOSE, "\n    " + f);
                                }
                                this.jobCounters.incrCounter((Enum)MapperCounter.FILES_ELIGIBLE, (long)bucketFiles.size());
                                partitionBucketer.add(crushFile);
                            }
                        }
                    }
                    if (!uncrushedFiles.isEmpty()) {
                        this.print(Verbosity.INFO, "\n\n  Skipped " + uncrushedFiles.size() + " files");
                        for (String uncrushed : uncrushedFiles) {
                            this.print(Verbosity.VERBOSE, "\n    " + uncrushed);
                        }
                        this.jobCounters.incrCounter((Enum)MapperCounter.FILES_SKIPPED, (long)uncrushedFiles.size());
                    }
                    this.skippedFiles.addAll(uncrushedFiles);
                }
                dirs = nextLevel;
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                LOG.error((Object)("Trapped exception during close: " + this.bucketFiles), (Throwable)e);
            }
        }
        List<Bucketer.Bucket> partitions = partitionBucketer.createBuckets();
        assert (partitions.size() <= numPartitions);
        writer = SequenceFile.createWriter((FileSystem)this.fs, (Configuration)this.job, (Path)this.partitionMap, Text.class, IntWritable.class);
        IntWritable partNum = new IntWritable();
        try {
            for (Bucketer.Bucket partition : partitions) {
                String partitionName = partition.name();
                partNum.set(Integer.parseInt(partitionName.substring(partitionName.lastIndexOf(45) + 1)));
                for (String bucketId : partition.contents()) {
                    key.set(bucketId);
                    writer.append((Writable)key, (Writable)partNum);
                }
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {
                LOG.error((Object)("Trapped exception during close: " + this.partitionMap), (Throwable)exception);
            }
        }
        FSDataOutputStream fSDataOutputStream = this.fs.create(this.counters);
        try {
            this.jobCounters.write((DataOutput)fSDataOutputStream);
        }
        finally {
            try {
                fSDataOutputStream.close();
            }
            catch (Exception e) {
                LOG.error((Object)("Trapped exception during close: " + this.partitionMap), (Throwable)e);
            }
        }
    }

    private String getPathPart(Path path) {
        this.pathMatcher.reset(path.toString());
        this.pathMatcher.matches();
        return this.pathMatcher.group(5);
    }

    JobConf getJob() {
        return this.job;
    }

    FileSystem getFileSystem() {
        return this.fs;
    }

    void setFileSystem(FileSystem fs) {
        this.fs = fs;
    }

    Path getTmpDir() {
        return this.tmpDir;
    }

    Path getBucketFiles() {
        return this.bucketFiles;
    }

    Path getPartitionMap() {
        return this.partitionMap;
    }

    Path getCounters() {
        return this.counters;
    }

    public Counters getJobCounters() {
        return this.jobCounters;
    }

    int getMaxFileBlocks() {
        return this.maxFileBlocks;
    }

    private int findMatcher(Path path) {
        for (int i = 0; i < this.matchers.size(); ++i) {
            Matcher matcher = this.matchers.get(i);
            matcher.reset(path.toUri().getPath());
            if (!matcher.matches()) continue;
            return i;
        }
        return -1;
    }

    private void print(Verbosity verbosity, String line) {
        if (verbosity.compareTo(this.console) >= 0) {
            System.out.print(line);
        }
    }

    public static void main(String[] args) throws Exception {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
        Crush crusher = new Crush();
        int exitCode = ToolRunner.run((Tool)crusher, (String[])args);
        System.exit(exitCode);
    }

    private static class NullOutputCollector<K, V>
    implements OutputCollector<K, V> {
        private NullOutputCollector() {
        }

        public void collect(K arg0, V arg1) throws IOException {
        }
    }

    private static enum Mode {
        STAND_ALONE,
        MAP_REDUCE,
        CLONE;

    }

    private static enum Verbosity {
        VERBOSE,
        INFO,
        NONE;

    }
}

