/*
 * Decompiled with CFR 0.152.
 */
package com.m6d.filecrush.crush;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Partitioner;

public class CrushPartitioner
implements Partitioner<Text, Text> {
    private Map<Text, Integer> bucketToPartition;

    public void configure(JobConf job) {
        String path = job.get("crush.partition.map");
        int expPartitions = job.getNumReduceTasks();
        this.bucketToPartition = new HashMap<Text, Integer>(100);
        try {
            FileSystem fs = FileSystem.get((Configuration)job);
            SequenceFile.Reader reader = new SequenceFile.Reader(fs, new Path(path), (Configuration)job);
            Text bucket = new Text();
            IntWritable partNum = new IntWritable();
            while (reader.next((Writable)bucket, (Writable)partNum)) {
                int partNumValue = partNum.get();
                if (partNumValue < 0 || partNumValue >= expPartitions) {
                    throw new IllegalArgumentException("Partition " + partNumValue + " not allowed with " + expPartitions + " reduce tasks");
                }
                Integer prev = this.bucketToPartition.put(new Text(bucket), partNumValue);
                if (null == prev) continue;
                throw new IllegalArgumentException("Bucket " + bucket + " appears more than once in " + path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read partition map from " + path, e);
        }
        if (new HashSet<Integer>(this.bucketToPartition.values()).size() > expPartitions) {
            throw new IllegalArgumentException(path + " contains more than " + expPartitions + " distinct partitions");
        }
    }

    public int getPartition(Text bucketId, Text fileName, int numPartitions) {
        return this.bucketToPartition.get(bucketId);
    }
}

