(ns com.madeye.auth.v1.crypt (:gen-class))

(java.security.Security/addProvider
 (org.bouncycastle.jce.provider.BouncyCastleProvider.))

(defn generate-keys []
  (let [generator (doto (java.security.KeyPairGenerator/getInstance "RSA" "BC")
                    (.initialize 2048))]
    (.generateKeyPair generator)))

(defn read-keys [f]
  (-> f
      java.io.FileReader.
      org.bouncycastle.openssl.PEMReader.
      .readObject))

(defn write-keys [f keys]
  (let [writer (org.bouncycastle.openssl.PEMWriter. (java.io.FileWriter. f))]
    (.writeObject writer keys)
    (.flush writer)))

(defn encrypt [bytes public-key]
  (let [cipher (doto (javax.crypto.Cipher/getInstance "RSA/ECB/PKCS1Padding" "BC")
                 (.init javax.crypto.Cipher/ENCRYPT_MODE public-key))]
    (.doFinal cipher bytes)))


(defn decrypt [bytes private-key]
  (let [cipher (doto (javax.crypto.Cipher/getInstance "RSA/ECB/PKCS1Padding" "BC")
                 (.init javax.crypto.Cipher/DECRYPT_MODE private-key))]
    (.doFinal cipher bytes)))


(defn sign [data private-key]
    (let [sig (doto (java.security.Signature/getInstance "SHA1withRSA" "BC")
                              (.initSign private-key (java.security.SecureRandom.))
                              (.update data))]
          (.sign sig)))

(defn verify [signuture data public-key]
    (let [sig (doto (java.security.Signature/getInstance "SHA1withRSA" "BC")
                              (.initVerify public-key)
                              (.update data))]
          (.verify sig signuture)))

(defn public [keys]
  (.getPublic keys)
)

(defn private [keys]
  (.getPrivate keys)
)

(defn get-bytes 
  [str]
  (.getBytes str)
)
