/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.model.v2.App;
import client.model.v2.DeleteAppTaskResponse;
import client.model.v2.DeleteAppTasksResponse;
import client.model.v2.Deployment;
import client.model.v2.GetAppResponse;
import client.model.v2.GetAppTasksResponse;
import client.model.v2.GetAppsResponse;
import client.model.v2.GetEventSubscriptionRegisterResponse;
import client.model.v2.GetEventSubscriptionsResponse;
import client.model.v2.GetServerInfoResponse;
import client.model.v2.GetTasksResponse;
import client.model.v2.Group;
import client.model.v2.QueueResponse;
import client.model.v2.Result;
import client.utils.MarathonException;
import feign.Param;
import feign.RequestLine;
import java.util.List;

public interface Marathon {
    @RequestLine(value="GET /v2/apps")
    public GetAppsResponse getApps() throws MarathonException;

    @RequestLine(value="GET /v2/apps/{id}")
    public GetAppResponse getApp(@Param(value="id") String var1) throws MarathonException;

    @RequestLine(value="GET /v2/apps/{id}/tasks")
    public GetAppTasksResponse getAppTasks(@Param(value="id") String var1) throws MarathonException;

    @RequestLine(value="GET /v2/tasks")
    public GetTasksResponse getTasks() throws MarathonException;

    @RequestLine(value="POST /v2/apps")
    public App createApp(App var1) throws MarathonException;

    @RequestLine(value="PUT /v2/apps/{app_id}?force={force}")
    public Result updateApp(@Param(value="app_id") String var1, App var2, @Param(value="force") boolean var3) throws MarathonException;

    @RequestLine(value="POST /v2/apps/{id}/restart?force={force}")
    public void restartApp(@Param(value="id") String var1, @Param(value="force") boolean var2) throws MarathonException;

    @RequestLine(value="DELETE /v2/apps/{id}")
    public Result deleteApp(@Param(value="id") String var1) throws MarathonException;

    @RequestLine(value="DELETE /v2/apps/{app_id}/tasks?host={host}&scale={scale}")
    public DeleteAppTasksResponse deleteAppTasks(@Param(value="app_id") String var1, @Param(value="host") String var2, @Param(value="scale") String var3) throws MarathonException;

    @RequestLine(value="DELETE /v2/apps/{app_id}/tasks/{task_id}?scale={scale}")
    public DeleteAppTaskResponse deleteAppTask(@Param(value="app_id") String var1, @Param(value="task_id") String var2, @Param(value="scale") String var3) throws MarathonException;

    @RequestLine(value="POST /v2/groups")
    public Result createGroup(Group var1) throws MarathonException;

    @RequestLine(value="DELETE /v2/groups/{id}")
    public Result deleteGroup(@Param(value="id") String var1) throws MarathonException;

    @RequestLine(value="GET /v2/groups/{id}")
    public Group getGroup(@Param(value="id") String var1) throws MarathonException;

    @RequestLine(value="GET /v2/deployments")
    public List<Deployment> getDeployments() throws MarathonException;

    @RequestLine(value="DELETE /v2/deployments/{deploymentId}")
    public void cancelDeploymentAndRollback(@Param(value="deploymentId") String var1) throws MarathonException;

    @RequestLine(value="DELETE /v2/deployments/{deploymentId}?force=true")
    public void cancelDeployment(@Param(value="deploymentId") String var1) throws MarathonException;

    @RequestLine(value="POST /v2/eventSubscriptions?callbackUrl={url}")
    public GetEventSubscriptionRegisterResponse register(@Param(value="url") String var1) throws MarathonException;

    @RequestLine(value="DELETE /v2/eventSubscriptions?callbackUrl={url}")
    public GetEventSubscriptionRegisterResponse unregister(@Param(value="url") String var1) throws MarathonException;

    @RequestLine(value="GET /v2/eventSubscriptions")
    public GetEventSubscriptionsResponse subscriptions() throws MarathonException;

    @RequestLine(value="GET /v2/queue")
    public QueueResponse getQueue() throws MarathonException;

    @RequestLine(value="GET /v2/info")
    public GetServerInfoResponse getServerInfo() throws MarathonException;
}

