/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.Marathon;
import client.auth.TokenAuthRequestInterceptor;
import client.utils.MarathonException;
import client.utils.ModelUtils;
import feign.Feign;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.Response;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.gson.GsonDecoder;
import feign.gson.GsonEncoder;
import java.util.Arrays;

public class MarathonClient {
    public static Marathon getInstance(String endpoint) {
        return MarathonClient.getInstance(endpoint, null);
    }

    public static Marathon getInstance(String endpoint, RequestInterceptor ... interceptors) {
        Feign.Builder b = Feign.builder().encoder((Encoder)new GsonEncoder(ModelUtils.GSON)).decoder((Decoder)new GsonDecoder(ModelUtils.GSON)).errorDecoder((ErrorDecoder)new MarathonErrorDecoder());
        if (interceptors != null) {
            b.requestInterceptors(Arrays.asList(interceptors));
        }
        b.requestInterceptor((RequestInterceptor)new MarathonHeadersInterceptor());
        return (Marathon)b.target(Marathon.class, endpoint);
    }

    public static Marathon getInstanceWithBasicAuth(String endpoint, String username, String password) {
        return MarathonClient.getInstance(endpoint, new RequestInterceptor[]{new BasicAuthRequestInterceptor(username, password)});
    }

    public static Marathon getInstanceWithTokenAuth(String endpoint, String token) {
        return MarathonClient.getInstance(endpoint, new TokenAuthRequestInterceptor(token));
    }

    static class MarathonErrorDecoder
    implements ErrorDecoder {
        MarathonErrorDecoder() {
        }

        public Exception decode(String methodKey, Response response) {
            return new MarathonException(response.status(), response.reason());
        }
    }

    static class MarathonHeadersInterceptor
    implements RequestInterceptor {
        MarathonHeadersInterceptor() {
        }

        public void apply(RequestTemplate template) {
            template.header("Accept", new String[]{"application/json"});
            template.header("Content-Type", new String[]{"application/json"});
        }
    }
}

