/*
 * Decompiled with CFR 0.152.
 */
package com.marathon.hazelcast.servicediscovery;

import com.hazelcast.cluster.Address;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.marathon.hazelcast.servicediscovery.MarathonDiscoveryConfiguration;
import com.marathon.hazelcast.servicediscovery.MarathonServiceDiscoveryHelper;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.stream.Collectors;

public class MarathonDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private String marathonEndpoint = (String)((Object)this.getOrNull("discovery.marathon", MarathonDiscoveryConfiguration.MARATHON_ENDPOINT));
    private String appId = (String)((Object)this.getOrNull("discovery.marathon", MarathonDiscoveryConfiguration.APP_ID));
    private int port = Integer.parseInt((String)((Object)this.getOrNull("discovery.marathon", MarathonDiscoveryConfiguration.PORT_INDEX)));
    private ILogger logger;

    public MarathonDiscoveryStrategy(final ILogger logger, Map<String, Comparable> properties) {
        super(logger, properties);
        this.logger = logger;
        try {
            MarathonServiceDiscoveryHelper.start(this.marathonEndpoint, this.appId, this.port, logger);
        }
        catch (Exception e) {
            logger.severe("Failed to start service discovery!", (Throwable)e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    MarathonServiceDiscoveryHelper.stop();
                }
                catch (Exception e) {
                    logger.severe("Error adding shutdown hook!", (Throwable)e);
                }
            }
        });
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        return MarathonServiceDiscoveryHelper.getAllNodes().stream().map(n -> {
            try {
                return new SimpleDiscoveryNode(new Address(n.getHost(), n.getPort()));
            }
            catch (UnknownHostException e) {
                this.logger.severe("Error adding discovered member", (Throwable)e);
                return null;
            }
        }).collect(Collectors.toList());
    }
}

