/*
 * Decompiled with CFR 0.152.
 */
package com.marathon.hazelcast.servicediscovery;

import client.Marathon;
import client.MarathonClient;
import client.model.v2.GetAppResponse;
import client.utils.MarathonException;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.logging.ILogger;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class MarathonServiceDiscoveryHelper {
    private static Marathon marathon;
    private static final AtomicReference<List<ServiceNode>> serviceNodes;
    private static ILogger log;
    private static ScheduledExecutorService scheduledExecutorService;

    public static void start(String marathonEndpoint, String appId, int portIndex, ILogger logger) throws Exception {
        marathon = MarathonClient.getInstance(marathonEndpoint);
        log = logger;
        MarathonPoller marathonPoller = new MarathonPoller(marathon, appId, portIndex);
        scheduledExecutorService.scheduleAtFixedRate(marathonPoller, 0L, 10L, TimeUnit.SECONDS);
    }

    public static List<ServiceNode> getAllNodes() {
        return serviceNodes.get();
    }

    public static void stop() throws Exception {
        scheduledExecutorService.shutdown();
    }

    static {
        serviceNodes = new AtomicReference(Collections.emptyList());
        scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    }

    public static class MarathonPoller
    implements Runnable {
        private final Marathon marathon;
        private final String app;
        private final int portIndex;

        public MarathonPoller(Marathon marathon, String app, int portIndex) {
            this.marathon = marathon;
            this.app = app;
            this.portIndex = portIndex;
        }

        @Override
        public void run() {
            try {
                GetAppResponse response = this.marathon.getApp(this.app);
                List<ServiceNode> nodes = response.getApp().getTasks().stream().map(task -> new ServiceNode(task.getHost(), (Integer)CollectionUtil.getItemAtPositionOrNull(task.getPorts(), (int)this.portIndex))).collect(Collectors.toList());
                nodes.forEach(n -> log.info("Fetched node: " + n.getHost() + ":" + n.getPort()));
                serviceNodes.getAndSet(nodes);
            }
            catch (MarathonException e) {
                log.severe("Error getting app metadata from marathon", (Throwable)e);
            }
        }
    }

    public static class ServiceNode {
        private String host;
        private int port;

        public ServiceNode(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }
}

