/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.password;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.Element;
import javax.swing.text.PasswordView;
import javax.swing.text.View;
import mdlaf.utils.MaterialDrawingUtils;

public class MaterialPasswordFieldUI
extends BasicPasswordFieldUI {
    protected static final String PROPERTY_LINE_COLOR = "lineColor";
    protected static final String PROPERTY_SELECTION_COLOR = "selectionColor";
    protected static final String PROPERTY_SELECTION_TEXT_COLOR = "selectedTextColor";
    protected boolean drawLine;
    protected Color activeBackground;
    protected Color activeForeground;
    protected Color inactiveBackground;
    protected Color inactiveForeground;
    protected Color colorLineInactive;
    protected Color colorLineActive;
    protected Color colorLine;
    protected Color background;
    protected FocusListener focusListenerColorLine;
    protected PropertyChangeListener propertyChangeListener;
    protected PropertyChangeSupport propertyChangeSupport;

    public MaterialPasswordFieldUI() {
        this(true);
    }

    public MaterialPasswordFieldUI(boolean drawLine) {
        this.drawLine = drawLine;
        this.focusListenerColorLine = new FocusListenerColorLine();
        this.propertyChangeListener = new MaterialPropertyChangeListener();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public static ComponentUI createUI(JComponent c) {
        return new MaterialPasswordFieldUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        JPasswordField passwordField = (JPasswordField)c;
        passwordField.setEchoChar('\u2022');
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.installMyDefaults();
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setFont(null);
        c.setBackground(null);
        c.setForeground(null);
        c.setBorder(null);
        c.setCursor(null);
        super.uninstallUI(c);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.getComponent().setBorder(null);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.getComponent().addFocusListener(this.focusListenerColorLine);
        this.getComponent().addPropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeSupport.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.getComponent().removeFocusListener(this.focusListenerColorLine);
        this.getComponent().removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeSupport.removePropertyChangeListener(this.propertyChangeListener);
        super.uninstallListeners();
    }

    @Override
    protected void paintBackground(Graphics g) {
        super.paintBackground(MaterialDrawingUtils.getAliasedGraphics(g));
    }

    @Override
    public void paintSafely(Graphics g) {
        super.paintSafely(g);
        this.paintLine(g);
    }

    protected void logicForChangeColorOnFocus(JComponent component, Color background, Color foreground) {
        if (background == null || foreground == null) {
            throw new IllegalArgumentException("Argument function null");
        }
        JPasswordField passField = (JPasswordField)component;
        passField.setForeground(foreground);
        passField.setSelectionColor(background);
        passField.setSelectedTextColor(foreground);
    }

    protected void installMyDefaults() {
        this.background = UIManager.getColor("PasswordField.background");
        this.activeBackground = UIManager.getColor("PasswordField.selectionBackground");
        this.activeForeground = UIManager.getColor("PasswordField.selectionForeground");
        this.inactiveBackground = UIManager.getColor("PasswordField.inactiveBackground");
        this.inactiveForeground = UIManager.getColor("PasswordField.inactiveForeground");
        this.colorLineInactive = UIManager.getColor("PasswordField[Line].inactiveColor");
        this.colorLineActive = UIManager.getColor("PasswordField[Line].activeColor");
        this.getComponent().setFont(UIManager.getFont("PasswordField.font"));
        this.colorLine = this.getComponent().hasFocus() && this.getComponent().isEditable() ? this.colorLineActive : this.colorLineInactive;
        this.getComponent().setSelectionColor(this.getComponent().hasFocus() && this.getComponent().isEnabled() ? this.activeBackground : this.inactiveBackground);
        this.getComponent().setSelectedTextColor(this.getComponent().hasFocus() && this.getComponent().isEnabled() ? this.activeForeground : this.inactiveForeground);
        this.getComponent().setForeground(this.getComponent().hasFocus() && this.getComponent().isEnabled() ? this.activeForeground : this.inactiveForeground);
        this.getComponent().setBorder(UIManager.getBorder("PasswordField.border"));
    }

    protected void logicForPropertyChange(Color newColor, boolean isForeground) {
        if (newColor == null) {
            return;
        }
        if (isForeground && !newColor.equals(this.activeForeground) && !newColor.equals(this.inactiveForeground)) {
            this.activeForeground = newColor;
            this.getComponent().repaint();
        }
        if (!(isForeground || newColor.equals(this.activeBackground) || newColor.equals(this.inactiveBackground))) {
            this.activeBackground = newColor;
            this.getComponent().repaint();
        }
    }

    protected void changeColorOnFocus(boolean hasFocus) {
        JPasswordField c = (JPasswordField)this.getComponent();
        if (c == null) {
            return;
        }
        if (hasFocus && this.activeBackground != null && this.activeForeground != null) {
            this.logicForChangeColorOnFocus(c, this.activeBackground, this.activeForeground);
            this.paintLine(c.getGraphics());
        }
        if (!hasFocus && this.inactiveBackground != null && this.inactiveForeground != null) {
            this.logicForChangeColorOnFocus(c, this.inactiveBackground, this.inactiveForeground);
            this.paintLine(c.getGraphics());
        }
        if (c.getGraphics() != null) {
            c.paint(c.getGraphics());
        }
    }

    protected synchronized void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null || propertyName.isEmpty() || oldValue == null || newValue == null) {
            throw new IllegalArgumentException("Some property null");
        }
        if (this.propertyChangeSupport == null || oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        if (this.propertyChangeSupport == null || oldValue == newValue) {
            return;
        }
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void paintLine(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        JPasswordField c = (JPasswordField)this.getComponent();
        if (this.drawLine) {
            int x = c.getInsets().left;
            int y = c.getInsets().top;
            int w = c.getWidth() - c.getInsets().left - c.getInsets().right;
            graphics.setColor(this.colorLine);
            graphics.fillRect(x, c.getHeight() - y, w, 1);
        }
    }

    @Override
    public View create(Element elem) {
        return new MaterialPasswordView(elem);
    }

    protected class MaterialPasswordView
    extends PasswordView {
        private MaterialPasswordView(Element elem) {
            super(elem);
        }

        @Override
        protected int drawEchoCharacter(Graphics g, int x, int y, char c) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            FontMetrics fm = g2.getFontMetrics();
            int r = fm.charWidth(c) - 2;
            g2.setPaint(MaterialPasswordFieldUI.this.getComponent().hasFocus() && MaterialPasswordFieldUI.this.getComponent().isEnabled() ? MaterialPasswordFieldUI.this.activeForeground : MaterialPasswordFieldUI.this.inactiveForeground);
            g2.fillOval(x + 1, y + 5 - fm.getAscent(), r, r);
            g2.dispose();
            return x + fm.charWidth(c);
        }
    }

    protected class MaterialPropertyChangeListener
    implements PropertyChangeListener {
        protected MaterialPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            Color newColor;
            if (MaterialPasswordFieldUI.this.getComponent() == null) {
                return;
            }
            if (pce.getPropertyName().equals(MaterialPasswordFieldUI.PROPERTY_SELECTION_COLOR)) {
                newColor = (Color)pce.getNewValue();
                MaterialPasswordFieldUI.this.logicForPropertyChange(newColor, false);
            }
            if (pce.getPropertyName().equals(MaterialPasswordFieldUI.PROPERTY_SELECTION_TEXT_COLOR)) {
                newColor = (Color)pce.getNewValue();
                MaterialPasswordFieldUI.this.logicForPropertyChange(newColor, true);
            }
            if (pce.getPropertyName().equals(MaterialPasswordFieldUI.PROPERTY_LINE_COLOR)) {
                MaterialPasswordFieldUI.this.colorLine = newColor = (Color)pce.getNewValue();
                MaterialPasswordFieldUI.this.getComponent().repaint();
            }
            if (pce.getPropertyName().equals("background")) {
                MaterialPasswordFieldUI.this.getComponent().repaint();
            }
        }
    }

    protected class FocusListenerColorLine
    implements FocusListener {
        protected FocusListenerColorLine() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            MaterialPasswordFieldUI.this.firePropertyChange(MaterialPasswordFieldUI.PROPERTY_LINE_COLOR, MaterialPasswordFieldUI.this.colorLineInactive, MaterialPasswordFieldUI.this.colorLineActive);
            MaterialPasswordFieldUI.this.changeColorOnFocus(true);
        }

        @Override
        public void focusLost(FocusEvent e) {
            MaterialPasswordFieldUI.this.firePropertyChange(MaterialPasswordFieldUI.PROPERTY_LINE_COLOR, MaterialPasswordFieldUI.this.colorLineActive, MaterialPasswordFieldUI.this.colorLineInactive);
            MaterialPasswordFieldUI.this.changeColorOnFocus(false);
        }
    }
}

