/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.spinner;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicSpinnerUI;
import mdlaf.animation.MaterialUIMovement;
import mdlaf.utils.MaterialDrawingUtils;

public class MaterialSpinnerUI
extends BasicSpinnerUI {
    public static ComponentUI createUI(JComponent c) {
        return new MaterialSpinnerUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        JSpinner spinner = (JSpinner)c;
        spinner.setOpaque(false);
        spinner.setFont(UIManager.getFont("Spinner.font"));
        spinner.setBackground(UIManager.getColor("Spinner.background"));
        spinner.setForeground(UIManager.getColor("Spinner.foreground"));
        spinner.setBorder(UIManager.getBorder("Spinner.border"));
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(MaterialDrawingUtils.getAliasedGraphics(g), c);
    }

    @Override
    protected Component createNextButton() {
        Icon icon = UIManager.getIcon("Spinner.nextButtonIcon");
        JButton button = icon != null ? new JButton(icon) : new BasicArrowButton(1);
        button.setOpaque(true);
        button.setFocusable(true);
        button.setBackground(UIManager.getColor("Spinner.arrowButtonBackground"));
        button.setBorder(UIManager.getBorder("Spinner.arrowButtonBorder"));
        if (UIManager.getBoolean("Spinner.mouseHoverEnabled")) {
            button.addMouseListener(MaterialUIMovement.getMovement(button, UIManager.getColor("Spinner.mouseHoverColor")));
        }
        this.installNextButtonListeners(button);
        button.setBorder(BorderFactory.createLineBorder(button.getBackground()));
        return button;
    }

    @Override
    protected Component createPreviousButton() {
        Icon icon = UIManager.getIcon("Spinner.previousButtonIcon");
        JButton button = icon != null ? new JButton(icon) : new BasicArrowButton(5);
        button.setOpaque(true);
        button.setBackground(UIManager.getColor("Spinner.arrowButtonBackground"));
        if (UIManager.getBoolean("Spinner.mouseHoverEnabled")) {
            button.addMouseListener(MaterialUIMovement.getMovement(button, UIManager.getColor("Spinner.mouseHoverColor")));
        }
        this.installPreviousButtonListeners(button);
        button.setBorder(BorderFactory.createLineBorder(button.getBackground()));
        return button;
    }
}

