/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.tree;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import mdlaf.components.textfield.MaterialTextFieldUI;

public class MaterialTreeCellEditor
extends DefaultTreeCellEditor {
    private JTextField textField;

    public MaterialTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
        super(tree, renderer);
        this.init();
    }

    public MaterialTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer, TreeCellEditor editor) {
        super(tree, renderer, editor);
        this.init();
    }

    private void init() {
        this.textField = new JTextField();
        this.textField.setUI(new MaterialTextFieldUI());
        this.textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    MaterialTreeCellEditor.this.stopCellEditing();
                }
            }
        });
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.textField.setText(value.toString());
        return this.textField;
    }

    @Override
    public Object getCellEditorValue() {
        return this.textField.getText();
    }
}

