/*
 * Decompiled with CFR 0.152.
 */
package com.medino;

import java.awt.image.BufferedImage;

public class cropper {
    public static BufferedImage getCroppedImage(BufferedImage source, double tolerance) {
        if (tolerance >= 1.0 || tolerance < 0.0) {
            throw new IllegalArgumentException("Tolerance must be between 0 (inclusive) and 1 (exclusive)");
        }
        int baseColor = source.getRGB(0, 0);
        int width = source.getWidth();
        int height = source.getHeight();
        int topY = Integer.MAX_VALUE;
        int topX = Integer.MAX_VALUE;
        int bottomY = -1;
        int bottomX = -1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (!cropper.colorWithinTolerance(baseColor, source.getRGB(x, y), tolerance)) continue;
                if (x < topX) {
                    topX = x;
                }
                if (y < topY) {
                    topY = y;
                }
                if (x > bottomX) {
                    bottomX = x;
                }
                if (y <= bottomY) continue;
                bottomY = y;
            }
        }
        BufferedImage destination = new BufferedImage(bottomX - topX + 1, bottomY - topY + 1, 2);
        destination.getGraphics().drawImage(source, 0, 0, destination.getWidth(), destination.getHeight(), topX, topY, bottomX + 1, bottomY + 1, null);
        return destination;
    }

    private static boolean colorWithinTolerance(int a, int b, double tolerance) {
        int aAlpha = (a & 0xFF000000) >>> 24;
        int bAlpha = (b & 0xFF000000) >>> 24;
        int aRed = (a & 0xFF0000) >>> 16;
        int bRed = (b & 0xFF0000) >>> 16;
        int aGreen = (a & 0xFF00) >>> 8;
        int bGreen = (b & 0xFF00) >>> 8;
        int aBlue = a & 0xFF;
        int bBlue = b & 0xFF;
        double distance = Math.sqrt((aAlpha - bAlpha) * (aAlpha - bAlpha) + (aRed - bRed) * (aRed - bRed) + (aGreen - bGreen) * (aGreen - bGreen) + (aBlue - bBlue) * (aBlue - bBlue));
        double percentAway = distance / 510.0;
        return percentAway > tolerance;
    }
}

