# pwdprotect

A Clojure library designed to protect passwords in config files.

## Usage

Add dependency to your project.clj file.

```
[com.middlesphere/pwdprotect "1.0.1"]
```

Also, BouncyCastle crypto library should be in classpath.
You can add it as development dependency in your project.clj:
```
            :profiles {
                       :dev      {:dependencies [[org.bouncycastle/bcprov-jdk15on "1.54"]]}
                       :provided {:dependencies [[org.bouncycastle/bcprov-jdk15on "1.54"]]}}
```

First, edit your config file and mark any line with passwords like this (ENCRYPT-THIS "to be encrypted")
Quotes around password are mandatory. Warning: only one password allowed per line!

Second, call encrypt-passwords-in-file function every time you start program before you read config file.
As encryption password should be used a String autogenerated someway in a program.
Example:
```
(pwdprotect.core/encrypt-passwords-in-file "myconfig.properties" (generate-const-password))
```
This function will encrypt all passwords in config file and 
put them as base64 string e.g. "Ua5T4UPIntu9GFvquVduDe4VV/Yg18dOG1n7sp5U5kw="

Third, when you parse a config file just decrypt passwords by pwdprotect.core/decrypt-password using a String 
password autogenerated someway in a program:
```
(pwdprotect.core/decrypt-password "Ua5T4UPIntu9GFvquVduDe4VV/Yg18dOG1n7sp5U5kw=" (generate-const-password))
```

Keep your secrets in safe. 

## License

Copyright © 2016 by Middlepshere.

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
