/*
 * Decompiled with CFR 0.152.
 */
package storm.kafka.bolt;

import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichBolt;
import backtype.storm.tuple.Tuple;
import java.util.Map;
import java.util.Properties;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KafkaBolt<K, V>
extends BaseRichBolt {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaBolt.class);
    public static final String TOPIC = "topic";
    public static final String KAFKA_BROKER_PROPERTIES = "kafka.broker.properties";
    public static final String BOLT_KEY = "key";
    public static final String BOLT_MESSAGE = "message";
    private Producer<K, V> producer;
    private OutputCollector collector;
    private String topic;

    public void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        Map configMap = (Map)stormConf.get(KAFKA_BROKER_PROPERTIES);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)configMap);
        ProducerConfig config = new ProducerConfig(properties);
        this.producer = new Producer(config);
        this.topic = (String)stormConf.get(TOPIC);
        this.collector = collector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Tuple input) {
        Object key = null;
        if (input.contains(BOLT_KEY)) {
            key = input.getValueByField(BOLT_KEY);
        }
        Object message = input.getValueByField(BOLT_MESSAGE);
        try {
            this.producer.send(new KeyedMessage(this.topic, key, message));
        }
        catch (Exception ex) {
            LOG.error("Could not send message with key '" + key + "' and value '" + message + "'", (Throwable)ex);
        }
        finally {
            this.collector.ack(input);
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }
}

