/*
 * Decompiled with CFR 0.152.
 */
package storm.kafka;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import storm.kafka.DynamicPartitionConnections;
import storm.kafka.KafkaUtils;
import storm.kafka.Partition;
import storm.kafka.PartitionCoordinator;
import storm.kafka.PartitionManager;
import storm.kafka.SpoutConfig;
import storm.kafka.StaticHosts;
import storm.kafka.ZkState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticCoordinator
implements PartitionCoordinator {
    Map<Partition, PartitionManager> _managers = new HashMap<Partition, PartitionManager>();
    List<PartitionManager> _allManagers = new ArrayList<PartitionManager>();

    public StaticCoordinator(DynamicPartitionConnections connections, Map stormConf, SpoutConfig config, ZkState state, int taskIndex, int totalTasks, String topologyInstanceId) {
        StaticHosts hosts = (StaticHosts)config.hosts;
        List<Partition> myPartitions = KafkaUtils.calculatePartitionsForTask(hosts.getPartitionInformation(), totalTasks, taskIndex);
        for (Partition myPartition : myPartitions) {
            this._managers.put(myPartition, new PartitionManager(connections, topologyInstanceId, state, stormConf, config, myPartition));
        }
        this._allManagers = new ArrayList<PartitionManager>(this._managers.values());
    }

    @Override
    public List<PartitionManager> getMyManagedPartitions() {
        return this._allManagers;
    }

    @Override
    public PartitionManager getManager(Partition partition) {
        return this._managers.get(partition);
    }
}

