(ns cloud-clj.api.response.data.schema.column.data
  (:require
    [clojure.spec.alpha :as s]))

(s/def ::name string?)
(s/def ::namespace string?)
(s/def ::audited boolean?)
(s/def ::default_data (s/nilable string?))
(s/def ::description (s/nilable string?))
(s/def ::extended boolean?)
(s/def ::immutable boolean?)
(s/def ::indexed boolean?)
(s/def ::maximum (s/nilable (s/and integer? pos?)))
(s/def ::minimum (s/nilable (s/and integer? (s/or :zero zero? :pos pos?))))
(s/def ::plural_name (s/nilable string?))
(s/def ::precision (s/nilable integer?))
(s/def ::primary boolean?)
(s/def ::relationship_id (s/nilable string?))
(s/def ::required boolean?)
(s/def ::schema_id string?)
(s/def ::singular_name (s/nilable string?))
(s/def ::sort (s/nilable integer?))
(s/def ::unique (s/nilable (s/and string? #{"namespace" "user" "global"})))
(s/def ::translated boolean?)

(s/def
  ::type
  (s/and
    string?
    #{"boolean" "code" "date" "datetime" "decimal" "encrypted" "float" "formula"
      "html" "id" "integer" "json" "list" "lookup" "markdown" "master" "password"
      "select" "text" "textarea" "url"})) 

(s/def ::data
  (s/keys
    :req-un [::name ::namespace ::audited ::default_data ::description ::extended
             ::immutable ::indexed ::maximum ::minimum ::plural_name ::precision
             ::primary ::relationship_id ::required ::schema_id ::singular_name
             ::sort ::type ::unique ::translated]))
