(ns cloud-clj.user
  (:require
    [cloud-clj.api :refer [first-id select-data insert-data! set-password!]]))

(defn get-instance
  "This function takes a session and an instance name and returns an instance
   record. If a record isn't found with the provided name, an exception is
   thrown."
  [session instance-name]
  (let [response
        (select-data
          session "platform" "instance"
          {:where {:name instance-name} :limit 1})
        instance (get-in response [:data 0 :data])]
    (when (nil? instance)
      (throw (ex-info "Instance not found."
                      {:instance-name instance-name})))
    instance))

(defn root-create-user!
  "This function creates a user in the Cloud API and handles looking up the
   instance and setting the password for you. This functions takes:
   session: an instance of a CloudSession.
   instance-name: The name of the instance that this user is getting put in.
   user: A map with the data for the user record.
   password: The initial password for the specified user.

   Returns the user record that got created."
  [session instance-name user password]
  (let [instance (get-instance session instance-name)
        user (merge user {:instance_id (:id instance)
                          :namespace (:namespace instance)})
        user-response (insert-data! session "platform" "user" user)]
    (set-password! session instance-name (:name user) password)
    (get-in user-response [:data 0])))
