(ns cloud-clj.conversation
  (:require
    [clj-uuid :as uuid]))

(def ^:dynamic *record-ns* nil)

(def fake-phrases
  ["Lorem ipsum dolor sit amet, consectetur adipiscing elit."
   "Fusce eleifend leo eget consectetur finibus."
   "Nulla scelerisque dolor vitae lacus fringilla, id imperdiet mauris finibus."
   "Nunc tempus odio eu lorem maximus fringilla."
   "Quisque suscipit turpis et ipsum facilisis, ac rhoncus nisl pharetra."
   "Etiam sodales augue id vulputate fringilla."
   "Quisque eget dui eu erat mollis eleifend id nec libero."
   "In sit amet odio ut enim gravida sodales."
   "Sed eu purus quis lectus ultricies porta."
   "Fusce auctor mi id dui condimentum facilisis."
   "Nullam non ipsum quis ipsum dapibus vulputate."
   "In lobortis mauris vitae neque rhoncus vestibulum."
   "Integer non augue in mauris tempus porttitor eget quis felis."
   "Sed feugiat nisl vitae dolor luctus pellentesque."
   "Donec convallis elit in finibus fermentum."
   "Quisque posuere ante eu volutpat ornare."
   "Donec imperdiet odio ut neque aliquet sollicitudin."
   "Sed condimentum lectus et ipsum cursus malesuada."
   "Mauris mattis lorem maximus tortor facilisis feugiat."
   "Vestibulum suscipit massa nec ullamcorper vulputate."
   "Vivamus consectetur velit non tellus scelerisque ultrices."
   "Duis in dui sit amet urna auctor aliquam."
   "In vehicula turpis sed nunc rutrum lobortis."
   "In id urna euismod, tincidunt risus vel, semper lacus."
   "Nam at velit at nunc iaculis volutpat in sit amet risus."
   "Proin eu leo tincidunt, auctor ipsum eget, tristique eros."
   "Nulla posuere risus ut finibus maximus."
   "Nulla ornare erat sed tortor ultricies egestas."
   "Morbi commodo nisi a risus molestie molestie."
   "Quisque auctor sem non posuere posuere."
   "Fusce a elit non ipsum vestibulum vehicula."
   "Nullam pretium est in dui posuere scelerisque."
   "Sed at ex rhoncus, facilisis sapien eu, sodales massa."
   "Phasellus consequat neque ut nisl ullamcorper luctus."
   "Donec id elit ac felis maximus volutpat quis a ligula."
   "Nam fermentum tortor non cursus feugiat."
   "Integer ac ipsum eu magna rutrum luctus et sed mauris."
   "Pellentesque lobortis tellus non mollis sodales."
   "Pellentesque eu arcu malesuada, interdum ligula eu, volutpat arcu."
   "Ut blandit massa quis faucibus iaculis."
   "Mauris sodales ipsum vitae fermentum rutrum."
   "Nullam sed neque laoreet, pellentesque sapien at, consequat ipsum."
   "Suspendisse quis leo non ligula pellentesque accumsan ut nec arcu."
   "Donec consequat nulla in mauris consectetur, ac cursus risus malesuada."
   "Sed interdum ipsum quis lectus tempus, id pharetra sem sodales."
   "Nulla laoreet neque semper, rhoncus sapien at, elementum lacus."
   "Sed pretium turpis at lectus lobortis, a fermentum mi egestas."
   "Ut vitae dolor efficitur, pellentesque tellus id, vehicula justo."
   "Nulla rutrum tellus vitae libero tristique, ac blandit massa pellentesque."
   "Nullam vel lectus in ex ornare venenatis."
   "Duis aliquet risus quis risus ullamcorper, vitae tincidunt erat finibus."
   "Curabitur nec nulla tempor, suscipit sapien sit amet, pulvinar felis."
   "Phasellus vitae urna ornare mi cursus ornare id quis ipsum."
   "Maecenas non lorem euismod, pellentesque metus non, interdum elit."
   "Nullam et dolor varius, condimentum nisl vitae, porttitor quam."
   "Nunc a tortor hendrerit, lacinia nulla sit amet, sodales dolor."
   "Sed id ex blandit, pharetra urna tincidunt, vestibulum nisi."
   "Curabitur viverra leo at dui faucibus dictum."
   "Curabitur vel elit tempus, luctus justo eu, ultricies tellus."])

(defn make-channel-record
  [channel-name channel-type]
  (let [new-record
        {:namespace *record-ns*
         :name channel-name
         :description (rand-nth fake-phrases)
         :type channel-type}]
    (assoc new-record :id
           (-> uuid/+null+
               (uuid/v5 *record-ns*)
               (uuid/v5 channel-name)))))

(defn make-channel-members [channel member-ids]
  (let [channel-id (:id channel)]
    (doall
      (for [user-id member-ids]
        {:namespace *record-ns*
         :channel channel-id
         :is_writable true
         :user user-id}))))

(defn make-message [channel user time-created]
  {:namespace *record-ns*
   :message (rand-nth fake-phrases)
   :user user
   :channel channel
   :created_date time-created
   :updated_date time-created})

(defn create-test-channel
  [record-ns channel-name channel-type member-ids number-of-messages]
  (binding [*record-ns* record-ns]
    (let [channel (make-channel-record channel-name channel-type)
          channel-members (make-channel-members channel member-ids)
          start-date (.minusSeconds (java.time.Instant/now) (* 5 number-of-messages))]
      {:channel channel
       :channel-members channel-members
       :channel-messages
       (doall
         (for [n (range number-of-messages)]
           (make-message (:id channel) (rand-nth member-ids)
                         (.toString (.plusSeconds start-date (* n 5))))))})))

(comment
  ;;; Testing code.
  (zprint.core/zprint
    (create-test-channel "pace" "general" "public" (list "abc123" "cde432") 20))

  )

