/*
 * Decompiled with CFR 0.152.
 */
package de.roderick.weberknecht;

import de.roderick.weberknecht.WebSocket;
import de.roderick.weberknecht.WebSocketEventHandler;
import de.roderick.weberknecht.WebSocketMessage;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class WebSocketReceiver
extends Thread {
    private DataInputStream input = null;
    private WebSocket websocket = null;
    private WebSocketEventHandler eventHandler = null;
    private volatile boolean stop = false;

    public WebSocketReceiver(DataInputStream input, WebSocket websocket) {
        this.input = input;
        this.websocket = websocket;
        this.eventHandler = websocket.getEventHandler();
    }

    @Override
    public void run() {
        ArrayList<Byte> messageBytes = new ArrayList<Byte>();
        while (!this.stop) {
            try {
                byte b = this.input.readByte();
                byte opcode = (byte)(b & 0xF);
                byte length = this.input.readByte();
                long payload_length = 0L;
                if (length < 126) {
                    payload_length = length;
                } else if (length == 126) {
                    payload_length = (0xFF & this.input.readByte()) << 8 | 0xFF & this.input.readByte();
                } else if (length == 127) {
                    payload_length = this.input.readLong();
                }
                int i = 0;
                while ((long)i < payload_length) {
                    messageBytes.add(this.input.readByte());
                    ++i;
                }
                Byte[] message = messageBytes.toArray(new Byte[messageBytes.size()]);
                WebSocketMessage ws_message = new WebSocketMessage(message);
                this.eventHandler.onMessage(ws_message);
                messageBytes.clear();
            }
            catch (IOException ioe) {
                this.handleError();
            }
        }
    }

    public void stopit() {
        this.stop = true;
    }

    public boolean isRunning() {
        return !this.stop;
    }

    private void handleError() {
        this.stopit();
        this.websocket.handleReceiverError();
    }
}

