# nedap.reloaded.browser-refresh

Ring middleware that adds an auto-refresh JS script to html responses, that will be triggered on Reloaded `reset`.

Fork of [ring-refresh](https://github.com/weavejester/ring-refresh), removing additional file-watchers (redundant given Reloaded),
and making the JS less obstrusive.                                   

## Project status

The functionality works, but the current implementation (a promise is `deref`ed with a timeout) consumes/blocks one of the webserver's threads. If the webserver is configured to use just a few threads, then the server will become susceptible to blocking for up to 60s if it's hit too often.

That would be solvable with core.async, but [http-kit#394](https://github.com/http-kit/http-kit/issues/394) is in the way (at least for Ring/http-kit users).

A Pedestal-compatible reimplementation could be easy, but currently I have no incentive to develop it since (sadly) I don't work with Pedestal daily.

As a workaround, you can configure your server to use e.g. 100 threads if the environment is `:development`.

## Installation

```clojure
[com.nedap.staffing-solutions/reloaded.browser-refresh "0.1.2"]
````

## ns organisation

`nedap.reloaded.browser-refresh.api` contains the sole function you seed to consume. 

## License

Copyright © 2012, James Reeves

Copyright © 2019-, Nedap

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
