(ns nedap.reloaded.browser-refresh.api
  (:require
   [compojure.core :as compojure]
   [nedap.reloaded.browser-refresh.impl :refer :all]
   [nedap.reloaded.browser-refresh.impl.script :as script]))

(defn wrap-refresh
  "This middleware adds an auto-refresh JS script to html responses,
  that will be triggered on Reloaded `reset`.

  It is unnecesary to integrate this middleware as a Sierra Component: detection of updates is automatic.

  `refresh-time` is the how often should the JS poll the server. e.g. 50 (ms) is fine.
  Note that by design the responses are blocking, taking up to 60s,
  so in practice a value of 50ms will not be noisy at all.

  NOTE: it is assumed (and required) that `handler` will be wrapped with `ring.middleware.params/wrap-params`."
  [handler refresh-time]
  {:pre [handler (integer? refresh-time)]}
  (reset! last-modified (moment))
  (->> (script/refresh-script refresh-time)
       (script/wrap-with-script handler)
       (compojure/routes (source-changed-route refresh-time))))
