(ns nedap.reloaded.browser-refresh.impl
  (:require
   [compojure.core :as compojure]
   [nedap.reloaded.browser-refresh.impl.script :as script])
  (:import
   (java.util Date UUID)))

(defn moment []
  (-> (Date.) .getTime))

(def last-modified (atom (moment)))

(defn watch-until [reference pred timeout-ms]
  {:post [(boolean? %)]}
  (let [result    (promise)
        watch-key (-> (UUID/randomUUID) str)]
    (try
      (add-watch reference
                 watch-key
                 (fn [_ _ _ value]
                   (when (pred value)
                     (deliver result true))))
      (or (pred @reference)
          (deref result timeout-ms false))
      (catch InterruptedException _ ;; a HTTP server restart
        true)
      (finally
        (remove-watch reference watch-key)))))

(defn source-changed-route [refresh-time]
  (compojure/GET "/____source_changed" [^String since]
    (let [since   (Long. since)
          timeout (- 60000 refresh-time)
          result  (watch-until last-modified
                               (fn [^Long last-modified]
                                 (> last-modified since))
                               timeout)]
      (str result))))
