(ns crimson.spec
  (:require [clojure.spec.alpha :as s])
  (:import (redis.clients.jedis JedisPoolConfig)))

(s/def ::pool-config
  (s/keys :opt-un [::max-total
                   ::max-idle
                   ::min-idle
                   ::max-wait-millis
                   ::min-evictable-time-millis]))

(s/def ::cluster-options
  (s/keys :req-un [::nodes
                   ::connection-timeout
                   ::socket-timeout
                   ::max-attempts
                   ::pool-config]))

(s/def ::max-total int?)
(s/def ::max-idle int?)
(s/def ::min-idle int?)
(s/def ::max-wait-millis number?)
(s/def ::min-evictable-time-millis number?)
(s/def ::host string?)
(s/def ::port int?)
(s/def ::node-param (s/keys :req-un [::host ::port]))
(s/def ::nodes (s/and (s/coll-of ::node-param) set?))
(s/def ::connection-timeout int?)
(s/def ::socket-timeout int?)
(s/def ::max-attempts int?)