/*
 * Decompiled with CFR 0.152.
 */
package com.noticeboard.shesha.examples.employee;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.noticeboard.shesha.examples.employee.databuilder.EmployeeDepartmentBuilder;
import com.noticeboard.shesha.examples.employee.databuilder.EmployeeIdentificationBuilder;
import com.noticeboard.shesha.examples.employee.databuilder.EmployeeInfoBuilder;
import com.noticeboard.shesha.examples.employee.databuilder.EmployeeLocationBuilder;
import com.noticeboard.shesha.examples.employee.databuilder.EmployeeSalaryBuilder;
import com.noticeboard.shesha.executor.DataBuilderExecutor;
import com.noticeboard.shesha.executor.exception.DataBuilderExecutorFailedException;
import com.noticeboard.shesha.job.Job;
import com.noticeboard.shesha.job.exception.JobInitException;
import com.noticeboard.shesha.job.impl.DefaultJob;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmployeeExample {
    public static void main(String[] args) throws JobInitException, DataBuilderExecutorFailedException {
        Map<String, Object> initialParams = EmployeeExample.getInitialParams();
        Map<String, Job> jobs = EmployeeExample.getJobs();
        DataBuilderExecutor executor = new DataBuilderExecutor();
        Object result = executor.execute(initialParams, jobs);
        System.out.println(result);
    }

    private static Map<String, Object> getInitialParams() {
        HashMap<String, Object> initialParams = new HashMap<String, Object>();
        initialParams.put("employeeName", "John Doe");
        initialParams.put("pincode", 560102);
        return initialParams;
    }

    private static Map<String, Job> getJobs() throws JobInitException {
        HashMap jobs = Maps.newHashMap();
        DefaultJob idJob = new DefaultJob(EmployeeIdentificationBuilder.class, new String[]{"{employeeName}"});
        jobs.put("employeeId", idJob);
        DefaultJob locationJob = new DefaultJob(EmployeeLocationBuilder.class, new String[]{"{pincode}"});
        jobs.put("location", locationJob);
        DefaultJob departmentJob = new DefaultJob(EmployeeDepartmentBuilder.class, new String[]{"{employeeId}"});
        jobs.put("department", departmentJob);
        DefaultJob salaryJob = new DefaultJob(EmployeeSalaryBuilder.class, new String[]{"{employeeId}", "{department}"});
        jobs.put("salary", salaryJob);
        ArrayList dependencies = Lists.newArrayList((Object[])new String[]{"{employeeName}", "{employeeId}", "{department}", "{salary}", "{location}"});
        DefaultJob infoJob = new DefaultJob(EmployeeInfoBuilder.class, (List)dependencies);
        jobs.put("info", infoJob);
        return jobs;
    }
}

