/*
 * Decompiled with CFR 0.152.
 */
package com.noticeboard.shesha.executor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.noticeboard.shesha.data.builder.DataBuilder;
import com.noticeboard.shesha.executor.DataSetAccessor;
import com.noticeboard.shesha.executor.exception.DataBuilderExecutorFailedException;
import com.noticeboard.shesha.job.Job;
import com.noticeboard.shesha.job.exception.BadDataSetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;

public class DataBuilderExecutor {
    private final BlockingQueue<DataSetAccessor> completionQueue = new LinkedBlockingQueue<DataSetAccessor>();

    public Object execute(Map<String, Object> initialParams, Map<String, Job> jobs) throws DataBuilderExecutorFailedException {
        Object result = null;
        HashMap responses = Maps.newHashMap();
        ArrayList dispatchedJobs = Lists.newArrayList();
        responses.putAll(initialParams);
        for (int remaining = jobs.size(); remaining > 0; --remaining) {
            for (String key : jobs.keySet()) {
                List dependencies;
                Map<String, Object> collectedDependencies;
                Job job = jobs.get(key);
                if (responses.containsKey(key) || dispatchedJobs.contains(key) || (collectedDependencies = this.collectDependencies(responses, dependencies = job.getDependencies())).size() != dependencies.size()) continue;
                this.dispatchTask(job, collectedDependencies, key);
                dispatchedJobs.add(key);
            }
            if (dispatchedJobs.isEmpty()) {
                throw new DataBuilderExecutorFailedException("No possible resolution of dependencies found.");
            }
            try {
                DataSetAccessor dataSet = this.completionQueue.take();
                System.out.println("Task generated: " + dataSet.getKey());
                result = dataSet.getResult();
                responses.put(dataSet.getKey(), result);
                dispatchedJobs.remove(dataSet.getKey());
                continue;
            }
            catch (Exception e) {
                throw new DataBuilderExecutorFailedException("Exception while executing DataBuilder", e);
            }
        }
        return result;
    }

    private Map<String, Object> collectDependencies(Map<String, Object> responses, List<String> dependencies) {
        HashMap collectedDependencies = Maps.newHashMap();
        for (String dependency : dependencies) {
            if (!responses.containsKey(dependency)) continue;
            collectedDependencies.put(dependency, responses.get(dependency));
        }
        return collectedDependencies;
    }

    private void dispatchTask(Job job, Map<String, Object> collectedDependencies, String key) {
        try {
            DataBuilder dataBuilder = job.getDataBuilder(collectedDependencies);
            CompletableFuture.supplyAsync(() -> {
                try {
                    return dataBuilder.execute();
                }
                catch (Exception e) {
                    return null;
                }
            }).thenAcceptAsync(result -> this.completionQueue.add(new DataSetAccessor(key, result)));
        }
        catch (BadDataSetException e) {
            e.printStackTrace();
        }
    }
}

