/*
 * Decompiled with CFR 0.152.
 */
package com.noticeboard.shesha.job.impl;

import com.google.common.collect.Lists;
import com.noticeboard.shesha.data.agent.DataBuilderAgent;
import com.noticeboard.shesha.data.builder.DataBuilder;
import com.noticeboard.shesha.data.entity.DataSet;
import com.noticeboard.shesha.data.exception.DataSetParseException;
import com.noticeboard.shesha.job.Job;
import com.noticeboard.shesha.job.exception.BadDataSetException;
import com.noticeboard.shesha.job.exception.JobInitException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

public class DefaultJob
implements Job {
    private final Class<? extends DataBuilder> dataBuilderClass;
    private final DataBuilderAgent agent;

    public DefaultJob(Class<? extends DataBuilder> dataBuilderClass, String ... args) throws JobInitException {
        this(dataBuilderClass, Lists.newArrayList((Object[])args));
    }

    public DefaultJob(Class<? extends DataBuilder> dataBuilderClass, List<String> args) throws JobInitException {
        this.dataBuilderClass = dataBuilderClass;
        try {
            this.agent = new DataBuilderAgent(args);
        }
        catch (DataSetParseException e) {
            throw new JobInitException("Job Initialisation Error", e);
        }
    }

    @Override
    public DataBuilder getDataBuilder(Map<String, Object> values) throws BadDataSetException {
        return this.getDataBuilder(new DataSet(values));
    }

    @Override
    public DataBuilder getDataBuilder(DataSet dataSet) throws BadDataSetException {
        try {
            Constructor<? extends DataBuilder> constructor = this.dataBuilderClass.getDeclaredConstructor(DataSet.class);
            return constructor.newInstance(dataSet);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new BadDataSetException("Unable to execute callable", e);
        }
    }

    @Override
    public List<String> getDependencies() {
        return this.agent.getDependencies();
    }
}

