;; Copyright (c) 2011-2014 Michael S. Klishin
;; Copyright (c) 2012 Toby Hede
;;
;; The use and distribution terms for this software are covered by the
;; Eclipse Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
;; which can be found in the file epl-v10.html at the root of this distribution.
;; By using this software in any fashion, you are agreeing to be bound by
;; the terms of this license.
;; You must not remove this notice, or any other, from this software.

(ns monger.db
  "Functions that provide operations on databases"
  (:refer-clojure :exclude [find remove count drop distinct empty?])
  (:import [com.mongodb Mongo DB DBCollection])
  (:require monger.core
            [monger.conversion :refer :all]))


;;
;; API
;;

(defn add-user
  "Adds a new user for this db"
  [^DB db ^String username ^chars password]
  (.addUser db username password))


(defn drop-db
  "Drops the currently set database (via core/set-db) or the specified database."
  [^DB db]
  (.dropDatabase db))

(defn get-collection-names
  "Returns a set containing the names of all collections in this database."
  ([^DB db]
     (set (.getCollectionNames db))))
