/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.quartz.mongo;

import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mulesoft.quartz.mongo.TriggerPersistenceHelper;
import java.util.Map;
import org.quartz.DateBuilder;
import org.quartz.impl.triggers.CalendarIntervalTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class CalendarIntervalTriggerPersistenceHelper
implements TriggerPersistenceHelper {
    private static final String TRIGGER_REPEAT_INTERVAL_UNIT = "repeatIntervalUnit";
    private static final String TRIGGER_REPEAT_INTERVAL = "repeatInterval";
    private static final String TRIGGER_TIMES_TRIGGERED = "timesTriggered";

    public boolean canHandleTriggerType(OperableTrigger trigger) {
        return trigger instanceof CalendarIntervalTriggerImpl && !((CalendarIntervalTriggerImpl)trigger).hasAdditionalProperties();
    }

    public DBObject injectExtraPropertiesForInsert(OperableTrigger trigger, DBObject original) {
        CalendarIntervalTriggerImpl t = (CalendarIntervalTriggerImpl)trigger;
        return BasicDBObjectBuilder.start((Map)original.toMap()).append(TRIGGER_REPEAT_INTERVAL_UNIT, (Object)t.getRepeatIntervalUnit().name()).append(TRIGGER_REPEAT_INTERVAL, (Object)t.getRepeatInterval()).append(TRIGGER_TIMES_TRIGGERED, (Object)t.getTimesTriggered()).get();
    }

    public OperableTrigger setExtraPropertiesAfterInstantiation(OperableTrigger trigger, DBObject stored) {
        Object timesTriggered;
        Object repeatInterval;
        CalendarIntervalTriggerImpl t = (CalendarIntervalTriggerImpl)trigger;
        String repeatIntervalUnit = (String)stored.get(TRIGGER_REPEAT_INTERVAL_UNIT);
        if (repeatIntervalUnit != null) {
            t.setRepeatIntervalUnit(DateBuilder.IntervalUnit.valueOf((String)repeatIntervalUnit));
        }
        if ((repeatInterval = stored.get(TRIGGER_REPEAT_INTERVAL)) != null) {
            t.setRepeatInterval(((Integer)repeatInterval).intValue());
        }
        if ((timesTriggered = stored.get(TRIGGER_TIMES_TRIGGERED)) != null) {
            t.setTimesTriggered(((Integer)timesTriggered).intValue());
        }
        return t;
    }
}

