/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.quartz.mongo;

import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mulesoft.quartz.mongo.TriggerPersistenceHelper;
import java.text.ParseException;
import java.util.Map;
import java.util.TimeZone;
import org.quartz.CronExpression;
import org.quartz.CronTrigger;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class CronTriggerPersistenceHelper
implements TriggerPersistenceHelper {
    private static final String TRIGGER_CRON_EXPRESSION = "cronExpression";
    private static final String TRIGGER_TIMEZONE = "timezone";

    public boolean canHandleTriggerType(OperableTrigger trigger) {
        return trigger instanceof CronTriggerImpl && !((CronTriggerImpl)trigger).hasAdditionalProperties();
    }

    public DBObject injectExtraPropertiesForInsert(OperableTrigger trigger, DBObject original) {
        CronTrigger t = (CronTrigger)trigger;
        return BasicDBObjectBuilder.start((Map)original.toMap()).append(TRIGGER_CRON_EXPRESSION, (Object)t.getCronExpression()).append(TRIGGER_TIMEZONE, (Object)t.getTimeZone().getID()).get();
    }

    public OperableTrigger setExtraPropertiesAfterInstantiation(OperableTrigger trigger, DBObject stored) {
        Object tz;
        CronTriggerImpl t = (CronTriggerImpl)trigger;
        Object expression = stored.get(TRIGGER_CRON_EXPRESSION);
        if (expression != null) {
            try {
                t.setCronExpression(new CronExpression((String)expression));
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if ((tz = stored.get(TRIGGER_TIMEZONE)) != null) {
            t.setTimeZone(TimeZone.getTimeZone((String)tz));
        }
        return t;
    }
}

