/*
 * Decompiled with CFR 0.152.
 */
package nuroko.coders;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import mikera.vectorz.AVector;
import mikera.vectorz.BitVector;
import nuroko.coders.AbstractCoder;
import nuroko.core.NurokoException;

public class ChoiceCoder<T>
extends AbstractCoder<T> {
    final int length;
    final Object[] choiceArray;
    final HashMap<T, Integer> choiceMap = new HashMap();

    public ChoiceCoder(Collection<T> choices) {
        this.length = choices.size();
        this.choiceArray = new Object[this.length];
        int i = 0;
        for (T t : choices) {
            this.choiceArray[i] = t;
            this.choiceMap.put(t, i);
            ++i;
        }
    }

    public ChoiceCoder(T ... values) {
        this((Collection<T>)Arrays.asList(values));
    }

    @Override
    public int codeLength() {
        return this.length;
    }

    @Override
    public T decode(AVector v, int offset) {
        int choice = 0;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.length; ++i) {
            double d = v.get(offset + i);
            if (!(d > max)) continue;
            max = d;
            choice = i;
        }
        return (T)this.choiceArray[choice];
    }

    @Override
    public void encode(T object, AVector dest, int offset) {
        Integer i = this.choiceMap.get(object);
        if (i == null) {
            throw new NurokoException("Choice value not found: " + object);
        }
        dest.fillRange(offset, this.length, 0.0);
        dest.set(offset + i, 1.0);
    }

    public List<?> getChoiceList() {
        return Arrays.asList(this.choiceArray);
    }

    @Override
    public AVector createOutputVector() {
        return BitVector.createLength((int)this.codeLength());
    }
}

