/*
 * Decompiled with CFR 0.152.
 */
package nuroko.module;

import java.util.ArrayList;
import java.util.List;
import mikera.util.Rand;
import mikera.vectorz.AVector;
import mikera.vectorz.Vector;
import nuroko.core.IComponent;
import nuroko.core.IInputState;
import nuroko.core.IModule;
import nuroko.module.loss.LossFunction;
import nuroko.module.loss.SquaredErrorLoss;

public abstract class AComponent
implements IComponent {
    public IComponent topComponent() {
        return this;
    }

    @Override
    public void think(AVector input, AVector output) {
        this.setInput(input);
        this.thinkInternal();
        if (output != null) {
            output.set(this.getOutput());
        }
    }

    @Override
    public void thinkInternalTraining() {
        this.thinkInternal();
    }

    @Override
    public AVector think(AVector input) {
        Vector output = Vector.createLength((int)this.getOutputLength());
        this.think(input, (AVector)output);
        return output;
    }

    public AVector generate(AVector output) {
        Vector input = Vector.createLength((int)this.getInputLength());
        this.generate((AVector)input, output);
        return input;
    }

    public void generate(AVector input, AVector output) {
        throw new UnsupportedOperationException("Can't do generate: " + this.getClass());
    }

    @Override
    public void train(AVector input, AVector target) {
        this.train(input, target, SquaredErrorLoss.INSTANCE, 1.0);
    }

    @Override
    public void train(AVector input, AVector target, LossFunction loss, double factor) {
        this.setInput(input);
        this.thinkInternalTraining();
        loss.calculateErrorDerivative(this.getOutput(), target, this);
        this.trainGradientInternal(factor);
        if (Rand.chance((double)0.1)) {
            this.applyConstraints();
        }
    }

    @Override
    public void trainGradient(AVector gradient, double factor) {
        this.getOutputGradient().set(gradient);
        this.trainGradientInternal(factor);
    }

    @Override
    public abstract void trainGradientInternal(double var1);

    @Override
    public void setInput(AVector inputValues) {
        this.getInput().set(inputValues);
    }

    @Override
    public void setOutput(AVector outputValues) {
        this.getOutput().set(outputValues);
    }

    @Override
    public int getParameterLength() {
        return this.getParameters().length();
    }

    public IComponent getComponent(int i) {
        return this.getComponents().get(i);
    }

    public List<IModule> getModules() {
        ArrayList<IModule> al = new ArrayList<IModule>();
        al.addAll(this.getComponents());
        return al;
    }

    @Override
    public IInputState getInputState() {
        return this;
    }

    @Override
    public int getInputLength() {
        return this.getInput().length();
    }

    @Override
    public int getOutputLength() {
        return this.getOutput().length();
    }

    @Override
    public boolean isStochastic() {
        return false;
    }

    @Override
    public void applyConstraints() {
        for (IComponent c : this.getComponents()) {
            c.applyConstraints();
        }
    }

    @Override
    public abstract AComponent clone();
}

