/*
 * Decompiled with CFR 0.152.
 */
package nuroko.module;

import java.util.ArrayList;
import java.util.List;
import mikera.vectorz.AVector;
import nuroko.core.IComponent;
import nuroko.module.ALayerStack;
import nuroko.module.AWeightLayer;
import nuroko.module.NeuralNet;

public class CompoundLayerStack
extends ALayerStack {
    private final int layerCount;
    private final int split;
    private final ALayerStack bottom;
    private final ALayerStack top;

    public CompoundLayerStack(ALayerStack a, ALayerStack b) {
        this.bottom = a;
        this.top = b;
        this.split = a.getLayerCount();
        this.layerCount = this.split + b.getLayerCount();
    }

    public static ALayerStack stack(ALayerStack a, ALayerStack b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return new CompoundLayerStack(a, b);
    }

    @Override
    public void thinkInternal() {
        throw new UnsupportedOperationException("CompoundLayerStack is view-only");
    }

    @Override
    public void trainGradientInternal(double factor) {
        throw new UnsupportedOperationException("CompoundLayerStack is view-only");
    }

    @Override
    public List<IComponent> getComponents() {
        ArrayList<IComponent> al = new ArrayList<IComponent>();
        al.add(this.bottom);
        al.add(this.top);
        return al;
    }

    @Override
    public AVector getParameters() {
        return this.bottom.getParameters().join(this.top.getParameters());
    }

    @Override
    public AVector getGradient() {
        return this.bottom.getGradient().join(this.top.getGradient());
    }

    @Override
    public void trainGradient(AVector gradient, double factor) {
        throw new UnsupportedOperationException("CompundLayerStack is view-only");
    }

    @Override
    public AVector getInputGradient() {
        return this.bottom.getInputGradient();
    }

    @Override
    public AVector getOutputGradient() {
        return this.top.getOutputGradient();
    }

    @Override
    public int getLayerCount() {
        return this.layerCount;
    }

    @Override
    public AWeightLayer getLayer(int i) {
        if (i < this.split) {
            return this.bottom.getLayer(i);
        }
        return this.top.getLayer(i - this.split);
    }

    @Override
    public AVector getData(int i) {
        if (i < this.split) {
            return this.bottom.getData(i);
        }
        return this.top.getData(i - this.split);
    }

    @Override
    public ALayerStack clone() {
        throw new UnsupportedOperationException("CompundLayerStack is view-only");
    }

    @Override
    public void train(AVector input, AVector target) {
        throw new UnsupportedOperationException("CompundLayerStack is view-only");
    }

    @Override
    public void trainGradient(AVector input, AVector outputGradient, AVector inputGradient, double factor, boolean skipTopDerivative) {
        throw new UnsupportedOperationException("CompundLayerStack is view-only");
    }

    public static ALayerStack create(List<AWeightLayer> layers) {
        ALayerStack c = null;
        for (AWeightLayer wl : layers) {
            c = CompoundLayerStack.stack(c, new NeuralNet(wl));
        }
        return c;
    }
}

