/*
 * Decompiled with CFR 0.152.
 */
package nuroko.module;

import java.util.Collections;
import java.util.List;
import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.Vector;
import mikera.vectorz.impl.Vector0;
import nuroko.core.IComponent;
import nuroko.module.AStateComponent;

public class Operator
extends AStateComponent {
    private final int length;
    private final Op op;

    public Operator(Op op, int inputLength) {
        super(inputLength, inputLength);
        this.length = inputLength;
        this.op = op;
    }

    @Override
    public void thinkInternal() {
        Vector output = this.getOutput();
        output.set((AVector)this.getInput());
        this.op.applyTo((AVector)output);
    }

    @Override
    public void trainGradient(AVector gradient, double factor) {
        this.getOutputGradient().set(gradient);
        this.trainGradientInternal(factor);
    }

    @Override
    public void trainGradientInternal(double factor) {
        Vector ig = this.getInputGradient();
        ig.fill(0.0);
        Vector output = this.getOutput();
        Vector gradient = this.getOutputGradient();
        int len = ig.length();
        for (int i = 0; i < len; ++i) {
            double y = output.get(i);
            ig.addAt(i, gradient.get(i) * this.op.derivativeForOutput(y));
        }
    }

    @Override
    public List<IComponent> getComponents() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public int getOutputLength() {
        return this.length;
    }

    @Override
    public AVector getGradient() {
        return Vector0.INSTANCE;
    }

    @Override
    public AVector getParameters() {
        return Vector0.INSTANCE;
    }

    @Override
    public Operator clone() {
        return new Operator(this.op, this.length);
    }

    @Override
    public int getInputLength() {
        return this.length;
    }

    @Override
    public boolean isStochastic() {
        return this.op.isStochastic();
    }
}

