/*
 * Decompiled with CFR 0.152.
 */
package nuroko.module;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mikera.vectorz.AVector;
import mikera.vectorz.Vector;
import nuroko.core.IComponent;
import nuroko.core.IConstraint;
import nuroko.core.IInputState;
import nuroko.core.IModule;
import nuroko.module.loss.LossFunction;
import nuroko.module.loss.SquaredErrorLoss;

public abstract class AComponent
implements IComponent,
Iterable<IComponent> {
    private double learnFactor = 1.0;
    private ArrayList<IConstraint> constraints = new ArrayList();

    public IComponent topComponent() {
        return this;
    }

    @Override
    public void think(AVector input, AVector output) {
        this.setInput(input);
        this.thinkInternal();
        if (output != null) {
            output.set(this.getOutput());
        }
    }

    @Override
    public void thinkInternalTraining() {
        this.thinkInternal();
    }

    @Override
    public AVector think(AVector input) {
        Vector output = Vector.createLength((int)this.getOutputLength());
        this.think(input, (AVector)output);
        return output;
    }

    public void setConstraint(IConstraint con) {
        this.constraints.clear();
        this.constraints.add(con);
    }

    public AVector generate(AVector output) {
        Vector input = Vector.createLength((int)this.getInputLength());
        this.generate((AVector)input, output);
        return input;
    }

    public void generate(AVector input, AVector output) {
        throw new UnsupportedOperationException("Can't do generate: " + this.getClass());
    }

    @Override
    public LossFunction getDefaultLossFunction() {
        return SquaredErrorLoss.INSTANCE;
    }

    @Override
    public final double getLearnFactor() {
        return this.learnFactor;
    }

    @Override
    public final void setLearnFactor(double value) {
        this.learnFactor = value;
    }

    @Override
    public final void train(AVector input, AVector target) {
        this.train(input, target, this.getDefaultLossFunction(), 1.0);
    }

    @Override
    public final void train(AVector input, AVector target, LossFunction loss, double factor) {
        this.setInput(input);
        this.thinkInternalTraining();
        loss.calculateErrorDerivative(this.getOutput(), target, this);
        this.trainGradientInternal(factor);
    }

    @Override
    public abstract void trainGradientInternal(double var1);

    @Override
    public void initRandom() {
        for (IComponent c : this.getComponents()) {
            c.initRandom();
        }
    }

    @Override
    public void setInput(AVector inputValues) {
        this.getInput().set(inputValues);
    }

    @Override
    public void setOutput(AVector outputValues) {
        this.getOutput().set(outputValues);
    }

    @Override
    public int getParameterLength() {
        return this.getParameters().length();
    }

    public IComponent getComponent(int i) {
        return this.getComponents().get(i);
    }

    public List<IModule> getModules() {
        ArrayList<IModule> al = new ArrayList<IModule>();
        al.addAll(this.getComponents());
        return al;
    }

    @Override
    public IInputState getInputState() {
        return this;
    }

    @Override
    public int getInputLength() {
        return this.getInput().length();
    }

    @Override
    public int getOutputLength() {
        return this.getOutput().length();
    }

    @Override
    public boolean isStochastic() {
        return false;
    }

    protected void applyConstraintsInternal() {
        for (IConstraint c : this.constraints) {
            c.applyTo(this);
        }
    }

    @Override
    public final void applyConstraints() {
        this.applyConstraintsInternal();
        for (IComponent c : this.getComponents()) {
            c.applyConstraints();
        }
    }

    @Override
    public AComponent clone() {
        AComponent c = null;
        try {
            c = (AComponent)super.clone();
            c.constraints = (ArrayList)this.constraints.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return c;
    }

    @Override
    public Iterator<IComponent> iterator() {
        return this.getComponents().iterator();
    }
}

