/*
 * Decompiled with CFR 0.152.
 */
package nuroko.module;

import java.util.Collections;
import java.util.List;
import mikera.indexz.Index;
import mikera.matrixx.AMatrix;
import mikera.vectorz.AVector;
import nuroko.core.IModule;
import nuroko.module.AStateComponent;

public abstract class AWeightLayer
extends AStateComponent {
    protected static final double INITIAL_WEIGHT_SCALE = 1.0;
    protected static final double BIAS_INITIAL_SCALE = 0.3;
    protected final int inputLength;
    protected final int outputLength;

    public AWeightLayer(int inputLength, int outputLength) {
        super(inputLength, outputLength);
        this.inputLength = inputLength;
        this.outputLength = outputLength;
    }

    @Override
    public List<IModule> getModules() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public int getInputLength() {
        return this.inputLength;
    }

    @Override
    public int getOutputLength() {
        return this.outputLength;
    }

    public abstract AWeightLayer getInverse();

    public abstract int getLinkCount(int var1);

    public abstract double getLinkWeight(int var1, int var2);

    public abstract int getLinkSource(int var1, int var2);

    public abstract Index getSourceIndex(int var1);

    public abstract AVector getSourceWeights(int var1);

    @Override
    public abstract AWeightLayer clone();

    public void trainGradient(AVector input, AVector outputGradient, AVector inputGradient, double factor) {
        this.getOutputGradient().set(outputGradient);
        this.getInput().set(input);
        this.trainGradientInternal(factor);
        inputGradient.set((AVector)this.getInputGradient());
    }

    @Override
    public abstract void initRandom();

    public abstract AMatrix asMatrix();
}

