/*
 * Decompiled with CFR 0.152.
 */
package nuroko.module.ops;

import mikera.vectorz.Op;

public final class ScaledLogistic
extends Op {
    private final double factor;
    private final double inverseFactor;
    public static final ScaledLogistic INSTANCE = new ScaledLogistic(6.0);

    public ScaledLogistic(double d) {
        this.factor = d;
        this.inverseFactor = 1.0 / d;
    }

    private double scaledLogisticFunction(double a) {
        double ea = Math.exp(-this.factor * a);
        double df = 1.0 / (1.0 + ea);
        if (Double.isNaN(df)) {
            return a > 0.0 ? 1.0 : 0.0;
        }
        return df;
    }

    private double inverseLogistic(double a) {
        if (a >= 1.0) {
            return 200.0;
        }
        if (a <= 0.0) {
            return -200.0;
        }
        double ea = a / (1.0 - a);
        return this.inverseFactor * Math.log(ea);
    }

    public double apply(double x) {
        return this.scaledLogisticFunction(x);
    }

    public double applyInverse(double y) {
        return this.inverseLogistic(y);
    }

    public void applyTo(double[] data, int start, int length) {
        for (int i = 0; i < length; ++i) {
            data[i + start] = this.scaledLogisticFunction(data[i + start]);
        }
    }

    public boolean hasDerivative() {
        return true;
    }

    public double derivativeForOutput(double y) {
        return this.factor * y * (1.0 - y);
    }

    public double derivative(double x) {
        double y = this.scaledLogisticFunction(x);
        return this.factor * y * (1.0 - y);
    }

    public double minValue() {
        return 0.0;
    }

    public double maxValue() {
        return 1.0;
    }

    public double averageValue() {
        return 0.5;
    }
}

