/*
 * Decompiled with CFR 0.152.
 */
package nuroko.module;

import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.Vector;
import nuroko.core.Components;
import nuroko.module.AOperationComponent;
import nuroko.module.loss.LossFunction;

public class Operator
extends AOperationComponent {
    private final Op op;

    public Operator(Op op, int length) {
        super(length);
        this.op = op;
    }

    @Override
    public void thinkInternal() {
        Vector output = this.getOutput();
        output.set((AVector)this.getInput());
        this.op.applyTo((AVector)output);
    }

    @Override
    public LossFunction getDefaultLossFunction() {
        return Components.defaultLossFunction(this.op);
    }

    @Override
    public void trainGradientInternal(double factor) {
        Vector ig = this.getInputGradient();
        ig.fill(0.0);
        Vector output = this.getOutput();
        Vector gradient = this.getOutputGradient();
        int len = ig.length();
        for (int i = 0; i < len; ++i) {
            double y = output.get(i);
            ig.addAt(i, gradient.get(i) * this.op.derivativeForOutput(y));
        }
    }

    @Override
    public Operator clone() {
        return new Operator(this.op, this.length);
    }

    @Override
    public boolean isStochastic() {
        return this.op.isStochastic();
    }

    @Override
    public boolean hasDifferentTrainingThinking() {
        return false;
    }
}

