/*
 * Decompiled with CFR 0.152.
 */
package nuroko.coders;

import mikera.vectorz.AVector;
import nuroko.coders.AbstractCoder;

public class IntegerCoder
extends AbstractCoder<Long> {
    private final int bits;

    public IntegerCoder() {
        this(64);
    }

    public IntegerCoder(int bits) {
        this.bits = bits;
    }

    @Override
    public Long decode(AVector v, int offset) {
        long value = 0L;
        for (int i = 0; i < this.bits; ++i) {
            value <<= 1;
            if (!(v.get(i) >= 0.5)) continue;
            value |= 1L;
        }
        return value;
    }

    @Override
    public void encode(Long value, AVector dest, int offset) {
        long mask = (1 << this.bits) - 1;
        long v = value & mask;
        long hibit = 1 << this.bits - 1;
        for (int i = 0; i < this.bits; ++i) {
            dest.set(i, (v & hibit) == 0L ? 0.0 : 1.0);
            v <<= 1;
        }
    }

    @Override
    public int codeLength() {
        return this.bits;
    }
}

