/*
 * Decompiled with CFR 0.152.
 */
package nuroko.coders;

import mikera.vectorz.AVector;
import nuroko.coders.AbstractCoder;
import nuroko.core.NurokoException;

public class DoubleCoder
extends AbstractCoder<Double> {
    private final double mean;
    private final double sd;

    public DoubleCoder(double mean, double sd) {
        this.mean = mean;
        this.sd = sd;
        if (sd == 0.0) {
            throw new NurokoException("Can't create DoubleCoder with zero sd");
        }
    }

    @Override
    public Double decode(AVector v, int offset) {
        return this.mean + this.sd * v.get(offset);
    }

    @Override
    public void encode(Double c, AVector dest, int offset) {
        dest.set(offset, (c - this.mean) / this.sd);
    }

    @Override
    public int codeLength() {
        return 1;
    }
}

