/*
 * Decompiled with CFR 0.152.
 */
package com.iclojure.jline;

import com.iclojure.jline.Terminal;
import com.iclojure.jline.TerminalFactory;
import com.iclojure.jline.internal.Configuration;
import com.iclojure.jline.internal.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class TerminalSupport
implements Terminal {
    public static final String JLINE_SHUTDOWNHOOK = "com.iclojure.jline.shutdownhook";
    public static final int DEFAULT_WIDTH = 80;
    public static final int DEFAULT_HEIGHT = 24;
    private Thread shutdownHook;
    private boolean shutdownHookEnabled;
    private boolean supported;
    private boolean echoEnabled;
    private boolean ansiSupported;
    private Configuration configuration;

    protected TerminalSupport(boolean supported) {
        this.supported = supported;
        this.shutdownHookEnabled = Configuration.getBoolean(JLINE_SHUTDOWNHOOK, false);
    }

    public void init() throws Exception {
        this.installShutdownHook(new RestoreHook());
    }

    public void restore() throws Exception {
        TerminalFactory.resetIf(this);
        this.removeShutdownHook();
    }

    public void reset() throws Exception {
        this.restore();
        this.init();
    }

    protected void installShutdownHook(Thread hook) {
        if (!this.shutdownHookEnabled) {
            Log.debug("Not install shutdown hook " + hook + " because they are disabled.");
            return;
        }
        assert (hook != null);
        if (this.shutdownHook != null) {
            throw new IllegalStateException("Shutdown hook already installed");
        }
        try {
            Runtime.getRuntime().addShutdownHook(hook);
            this.shutdownHook = hook;
        }
        catch (AbstractMethodError e) {
            Log.trace("Failed to register shutdown hook: ", e);
        }
    }

    protected void removeShutdownHook() {
        if (!this.shutdownHookEnabled) {
            return;
        }
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (AbstractMethodError e) {
                Log.trace("Failed to remove shutdown hook: ", e);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.shutdownHook = null;
        }
    }

    public final boolean isSupported() {
        return this.supported;
    }

    public synchronized boolean isAnsiSupported() {
        return this.ansiSupported;
    }

    protected synchronized void setAnsiSupported(boolean supported) {
        this.ansiSupported = supported;
        Log.debug("Ansi supported: ", supported);
    }

    public OutputStream wrapOutIfNeeded(OutputStream out) {
        return out;
    }

    public boolean hasWeirdWrap() {
        return true;
    }

    public int getWidth() {
        return 80;
    }

    public int getHeight() {
        return 24;
    }

    public synchronized boolean isEchoEnabled() {
        return this.echoEnabled;
    }

    public synchronized void setEchoEnabled(boolean enabled) {
        this.echoEnabled = enabled;
        Log.debug("Echo enabled: ", enabled);
    }

    public InputStream wrapInIfNeeded(InputStream in) throws IOException {
        return in;
    }

    protected class RestoreHook
    extends Thread {
        protected RestoreHook() {
        }

        public void start() {
            try {
                TerminalSupport.this.restore();
            }
            catch (Exception e) {
                Log.trace("Failed to restore: ", e);
            }
        }
    }
}

