/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.common.util;

import com.spotify.dns.DnsSrvResolvers;
import com.spotify.dns.LookupResult;
import com.spotify.dns.statistics.DnsReporter;
import com.spotify.dns.statistics.DnsTimingContext;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MesosDnsResolver {
    private static final Logger log = LoggerFactory.getLogger(MesosDnsResolver.class);
    private final DnsReporter dnsReporter = new DnsReporter(){

        public DnsTimingContext resolveTimer() {
            return new DnsTimingContext(){
                private final long start = System.currentTimeMillis();

                public void stop() {
                    long now = System.currentTimeMillis();
                    long diff = now - this.start;
                    log.info("Request took " + diff + "ms");
                }
            };
        }

        public void reportEmpty() {
            log.info("Empty response from server.");
        }

        public void reportFailure(Throwable error) {
            log.info("Error when resolving: " + error);
        }
    };

    public List<LookupResult> dnsSrvLookup(String url) {
        return DnsSrvResolvers.newBuilder().cachingLookups(true).retainingDataOnFailures(true).metered(this.dnsReporter).dnsLookupTimeoutMillis(1000L).build().resolve(url);
    }
}

