/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.compute.builder;

import com.google.common.collect.ImmutableSet;
import com.olacabs.fabric.compute.builder.impl.ArtifactoryJarPathResolver;
import com.olacabs.fabric.compute.builder.impl.RepositoryPrefix;
import com.olacabs.fabric.model.common.ComponentSource;
import com.olacabs.fabric.model.common.ComponentSourceVisitor;
import com.olacabs.fabric.model.common.sources.ArtifactoryComponentSource;
import com.olacabs.fabric.model.common.sources.JarComponentSource;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentUrlResolver
implements ComponentSourceVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentUrlResolver.class);
    private ImmutableSet.Builder<String> listBuilder = ImmutableSet.builder();

    public static Collection<String> urls(Collection<ComponentSource> sources) {
        ComponentUrlResolver resolver = new ComponentUrlResolver();
        sources.forEach(source -> source.accept((ComponentSourceVisitor)resolver));
        return resolver.listBuilder.build();
    }

    public void visit(ArtifactoryComponentSource artifactoryComponentSource) {
        try {
            LOGGER.info("Resolving artifactory url with {} , {}, {}, {}", new Object[]{artifactoryComponentSource.getArtifactoryUrl(), artifactoryComponentSource.getGroupId(), artifactoryComponentSource.getArtifactId(), artifactoryComponentSource.getVersion()});
            this.listBuilder.add((Object)ArtifactoryJarPathResolver.resolve(artifactoryComponentSource.getArtifactoryUrl(), artifactoryComponentSource.getGroupId(), artifactoryComponentSource.getArtifactId(), artifactoryComponentSource.getVersion(), new RepositoryPrefix(artifactoryComponentSource.getRepositorySnapshotsPrefix(), artifactoryComponentSource.getRepositoryReleasesPrefix())));
        }
        catch (Exception e) {
            LOGGER.error("Runtime Exception  ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void visit(JarComponentSource jarComponentSource) {
        this.listBuilder.add((Object)jarComponentSource.getUrl());
    }
}

