/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.compute.builder.impl;

import com.google.common.base.Strings;
import com.olacabs.fabric.compute.builder.impl.JarDownloader;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpJarDownloader
implements JarDownloader {
    private static final Logger log = LoggerFactory.getLogger(HttpJarDownloader.class);
    private final String tmpDirectory;
    private final CloseableHttpClient httpClient;

    public HttpJarDownloader() throws Exception {
        FileAttribute<Set<PosixFilePermission>> perms = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxr-xr-x"));
        Path createdPath = Files.createTempDirectory(null, perms);
        this.tmpDirectory = createdPath.toAbsolutePath().toString();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(20);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    @Override
    public Path download(String url) {
        HttpGet httpGet = new HttpGet(URI.create(url));
        CloseableHttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)httpGet);
            if (200 != response.getStatusLine().getStatusCode()) {
                throw new RuntimeException(String.format("Server returned [%d][%s] for url: %s", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), url));
            }
            Header[] headers = response.getHeaders("Content-Disposition");
            String filename = null;
            if (null != headers) {
                for (Header header : headers) {
                    for (HeaderElement headerElement : header.getElements()) {
                        NameValuePair attachment;
                        if (!headerElement.getName().equalsIgnoreCase("attachment") || (attachment = headerElement.getParameterByName("filename")) == null) continue;
                        filename = attachment.getValue();
                    }
                }
            }
            if (Strings.isNullOrEmpty(filename)) {
                String[] stringArray = url.split("/");
                filename = stringArray[stringArray.length - 1];
            }
            Path path = Files.write(Paths.get(this.tmpDirectory, filename), EntityUtils.toByteArray((HttpEntity)response.getEntity()), new OpenOption[0]);
            return path;
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading class from: " + url, e);
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    log.error("Could not close connection to server: ", (Throwable)e);
                }
            }
        }
    }
}

