/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.compute.builder.impl;

import com.olacabs.fabric.compute.builder.Loader;
import com.olacabs.fabric.compute.processor.ProcessorBase;
import com.olacabs.fabric.compute.source.PipelineSource;
import com.olacabs.fabric.model.common.ComponentMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class RegisteringLoader
implements Loader {
    private Map<String, PipelineSource> sources;
    private Map<String, ProcessorBase> stages;

    @Override
    public PipelineSource loadSource(ComponentMetadata source) {
        return this.sources.get(source.getName());
    }

    @Override
    public ProcessorBase loadProcessor(ComponentMetadata processor) {
        return this.stages.get(processor.getName());
    }

    @Override
    public int getSourceCount() {
        return this.sources.size();
    }

    @Override
    public int getProcessorCount() {
        return this.stages.size();
    }

    RegisteringLoader(Map<String, PipelineSource> sources, Map<String, ProcessorBase> stages) {
        this.sources = sources;
        this.stages = stages;
    }

    public static RegisteringLoaderBuilder builder() {
        return new RegisteringLoaderBuilder();
    }

    public static class RegisteringLoaderBuilder {
        private ArrayList<String> sources$key;
        private ArrayList<PipelineSource> sources$value;
        private ArrayList<String> stages$key;
        private ArrayList<ProcessorBase> stages$value;

        RegisteringLoaderBuilder() {
        }

        public RegisteringLoaderBuilder source(String sourceKey, PipelineSource sourceValue) {
            if (this.sources$key == null) {
                this.sources$key = new ArrayList();
                this.sources$value = new ArrayList();
            }
            this.sources$key.add(sourceKey);
            this.sources$value.add(sourceValue);
            return this;
        }

        public RegisteringLoaderBuilder sources(Map<? extends String, ? extends PipelineSource> sources) {
            if (this.sources$key == null) {
                this.sources$key = new ArrayList();
                this.sources$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends PipelineSource> $lombokEntry : sources.entrySet()) {
                this.sources$key.add($lombokEntry.getKey());
                this.sources$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public RegisteringLoaderBuilder clearSources() {
            if (this.sources$key != null) {
                this.sources$key.clear();
                this.sources$value.clear();
            }
            return this;
        }

        public RegisteringLoaderBuilder stage(String stageKey, ProcessorBase stageValue) {
            if (this.stages$key == null) {
                this.stages$key = new ArrayList();
                this.stages$value = new ArrayList();
            }
            this.stages$key.add(stageKey);
            this.stages$value.add(stageValue);
            return this;
        }

        public RegisteringLoaderBuilder stages(Map<? extends String, ? extends ProcessorBase> stages) {
            if (this.stages$key == null) {
                this.stages$key = new ArrayList();
                this.stages$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends ProcessorBase> $lombokEntry : stages.entrySet()) {
                this.stages$key.add($lombokEntry.getKey());
                this.stages$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public RegisteringLoaderBuilder clearStages() {
            if (this.stages$key != null) {
                this.stages$key.clear();
                this.stages$value.clear();
            }
            return this;
        }

        public RegisteringLoader build() {
            Map<String, ProcessorBase> stages;
            Map<String, PipelineSource> sources;
            switch (this.sources$key == null ? 0 : this.sources$key.size()) {
                case 0: {
                    sources = Collections.emptyMap();
                    break;
                }
                case 1: {
                    sources = Collections.singletonMap(this.sources$key.get(0), this.sources$value.get(0));
                    break;
                }
                default: {
                    sources = new LinkedHashMap(this.sources$key.size() < 0x40000000 ? 1 + this.sources$key.size() + (this.sources$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.sources$key.size(); ++$i) {
                        sources.put(this.sources$key.get($i), this.sources$value.get($i));
                    }
                    sources = Collections.unmodifiableMap(sources);
                }
            }
            switch (this.stages$key == null ? 0 : this.stages$key.size()) {
                case 0: {
                    stages = Collections.emptyMap();
                    break;
                }
                case 1: {
                    stages = Collections.singletonMap(this.stages$key.get(0), this.stages$value.get(0));
                    break;
                }
                default: {
                    stages = new LinkedHashMap<String, ProcessorBase>(this.stages$key.size() < 0x40000000 ? 1 + this.stages$key.size() + (this.stages$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.stages$key.size(); ++$i) {
                        stages.put(this.stages$key.get($i), this.stages$value.get($i));
                    }
                    stages = Collections.unmodifiableMap(stages);
                }
            }
            return new RegisteringLoader(sources, stages);
        }

        public String toString() {
            return "RegisteringLoader.RegisteringLoaderBuilder(sources$key=" + this.sources$key + ", sources$value=" + this.sources$value + ", stages$key=" + this.stages$key + ", stages$value=" + this.stages$value + ")";
        }
    }
}

