/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.compute.util;

import com.olacabs.fabric.compute.util.ComponentPropertyReader;
import com.olacabs.fabric.model.common.ComponentMetadata;
import com.olacabs.fabric.model.common.ComponentType;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class ComponentPropertyReaderTest {
    @Test
    public void testReadString() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("source.source_1.zookeeper", "localhost");
        Properties globalProperties = new Properties();
        String connStr = ComponentPropertyReader.readString((Properties)properties, (Properties)globalProperties, (String)"zookeeper", (String)"source_1", (ComponentMetadata)ComponentMetadata.builder().namespace("global").name("source").id("1234").type(ComponentType.SOURCE).build());
        Assert.assertEquals((Object)"localhost", (Object)connStr);
    }

    @Test
    public void testReadInteger() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("source.source_1.zookeeper", "10000");
        Properties globalProperties = new Properties();
        int connStr = ComponentPropertyReader.readInteger((Properties)properties, (Properties)globalProperties, (String)"zookeeper", (String)"source_1", (ComponentMetadata)ComponentMetadata.builder().namespace("global").name("source").id("1234").type(ComponentType.SOURCE).build());
        Assert.assertEquals((long)10000L, (long)connStr);
    }

    @Test
    public void testReadIntegerFromGlobal() {
        Properties properties = new Properties();
        Properties globalProperties = new Properties();
        globalProperties.setProperty("source.source_1.brokers", "localhost:9092");
        globalProperties.setProperty("source.source_1.topic-name", "x");
        globalProperties.setProperty("processor.processor_1.queueSize", "100");
        globalProperties.setProperty("source.source_1.zookeeper", "localhost:2181");
        int connStr = ComponentPropertyReader.readInteger((Properties)properties, (Properties)globalProperties, (String)"queueSize", (String)"processor_1", (ComponentMetadata)ComponentMetadata.builder().namespace("global").name("source").id("1234").type(ComponentType.PROCESSOR).build());
        Assert.assertEquals((long)100L, (long)connStr);
    }

    @Test
    public void testReadLong() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("source.source_1.zookeeper", "10000");
        Properties globalProperties = new Properties();
        long connStr = ComponentPropertyReader.readLong((Properties)properties, (Properties)globalProperties, (String)"zookeeper", (String)"source_1", (ComponentMetadata)ComponentMetadata.builder().namespace("global").name("source").id("1234").type(ComponentType.SOURCE).build());
        Assert.assertEquals((long)10000L, (long)connStr);
    }

    @Test
    public void testReadBoolean() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("source.source_1.zookeeper", "true");
        Properties globalProperties = new Properties();
        boolean connStr = ComponentPropertyReader.readBoolean((Properties)properties, (Properties)globalProperties, (String)"zookeeper", (String)"source_1", (ComponentMetadata)ComponentMetadata.builder().namespace("global").name("source").id("1234").type(ComponentType.SOURCE).build());
        Assert.assertEquals((Object)true, (Object)connStr);
    }
}

