/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.compute.builder.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.olacabs.fabric.compute.builder.impl.RepositoryPrefix;
import java.io.InputStream;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jfrog.artifactory.client.Artifactory;
import org.jfrog.artifactory.client.ArtifactoryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ArtifactoryJarPathResolver {
    private static final Logger log = LoggerFactory.getLogger(ArtifactoryJarPathResolver.class);

    private ArtifactoryJarPathResolver() {
    }

    public static String resolve(String artifactoryUrl, String groupId, String artifactId, String version) throws Exception {
        return ArtifactoryJarPathResolver.resolve(artifactoryUrl, groupId, artifactId, version, new RepositoryPrefix());
    }

    public static String resolve(String artifactoryUrl, String groupId, String artifactId, String version, RepositoryPrefix repositoryPrefix) throws Exception {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)artifactoryUrl) ? 1 : 0) != 0, (Object)"Artifactory URL cannot be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupId) ? 1 : 0) != 0, (Object)"Group Id cannot be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)artifactId) ? 1 : 0) != 0, (Object)"Artifact Id cannot be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)version) ? 1 : 0) != 0, (Object)"Artifact version cannot be null");
        boolean isSnapshot = version.contains("SNAPSHOT");
        log.info("Artifact is snapshot: {}", (Object)isSnapshot);
        String repoName = isSnapshot ? repositoryPrefix.getSnapshotsPrefix() : repositoryPrefix.getReleasesPrefix();
        Artifactory client = ArtifactoryClient.create((String)artifactoryUrl);
        log.info("Aritifactory client created successfully with uri {}", (Object)client.getUri());
        String metadataStr = isSnapshot ? String.format("%s/%s/%s/maven-metadata.xml", groupId.replaceAll("\\.", "/"), artifactId, version) : String.format("%s/%s/maven-metadata.xml", groupId.replaceAll("\\.", "/"), artifactId);
        log.info("Repo-name - {}, metadataStr - {}", (Object)repoName, (Object)metadataStr);
        InputStream response = client.repository(repoName).download(metadataStr).doDownload();
        Optional<String> resolvedVersion = ArtifactoryJarPathResolver.getResolvedVersion(response);
        String url = String.format("%s/%s/%s/%s/%s/%s-%s.jar", artifactoryUrl, repoName, groupId.replaceAll("\\.", "/"), artifactId, version, artifactId, resolvedVersion.orElse(version));
        log.info("Jar will be downloaded from: " + url);
        return url;
    }

    private static Optional<String> getResolvedVersion(InputStream inputStream) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            doc.normalize();
            Element metadata = (Element)doc.getElementsByTagName("metadata").item(0);
            return Optional.of(metadata.getTextContent().replaceAll("\\n\\s+", " ").split("jar")[1].split(" ")[1]);
        }
        catch (Exception e) {
            log.error("Error while trying to parse version from xml link");
            return Optional.empty();
        }
    }
}

