/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.compute.builder.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.olacabs.fabric.compute.builder.impl.JarDownloader;
import com.olacabs.fabric.compute.processor.ProcessorBase;
import com.olacabs.fabric.compute.source.PipelineSource;
import com.olacabs.fabric.model.common.ComponentMetadata;
import com.olacabs.fabric.model.common.ComponentType;
import com.olacabs.fabric.model.processor.Processor;
import com.olacabs.fabric.model.source.Source;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.conn.UnsupportedSchemeException;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarScanner {
    private static final Logger log = LoggerFactory.getLogger(JarScanner.class);
    private static final String PROPERTIES_FILE_NAME = "compute.properties";
    private Properties properties = new Properties();

    public JarScanner() throws Exception {
        this.properties.load(JarScanner.class.getResourceAsStream("/compute.properties"));
    }

    private URL[] genUrls(URL[] jarFileURLs) {
        URLClassLoader loader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] originalURLs = loader.getURLs();
        HashSet<URL> mergedJarURLs = new HashSet<URL>(originalURLs.length + jarFileURLs.length);
        mergedJarURLs.addAll(Arrays.asList(originalURLs));
        mergedJarURLs.addAll(Arrays.asList(jarFileURLs));
        return mergedJarURLs.toArray(new URL[mergedJarURLs.size()]);
    }

    private ClassLoader createClassLoader(URL[] urls) {
        URLClassLoader l = new URLClassLoader(urls);
        return l;
    }

    public List<ScanResult> loadJars(Collection<String> urls, ClassLoader parentLoader) throws Exception {
        URL[] downloadedUrls = this.genUrls(this.download(urls));
        ClassLoader child = this.createClassLoader(downloadedUrls);
        Thread.currentThread().setContextClassLoader(child);
        return ImmutableList.builder().addAll(this.scanForProcessors(child, downloadedUrls)).addAll(this.scanForSources(child, downloadedUrls)).build();
    }

    URL[] download(Collection<String> urls) {
        ArrayList downloadedURLs = urls.stream().map(url -> {
            URI uri = URI.create(url);
            String downloaderImplClassName = this.properties.getProperty(String.format("fs.%s.impl", uri.getScheme()));
            if (null == downloaderImplClassName) {
                throw new RuntimeException((Throwable)new UnsupportedSchemeException(uri.getScheme() + " is not supported for downloading jars"));
            }
            try {
                Class<?> clazz = Class.forName(downloaderImplClassName);
                if (JarDownloader.class.isAssignableFrom(clazz)) {
                    try {
                        return ((JarDownloader)clazz.newInstance()).download((String)url).toUri().toURL();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new RuntimeException("Unsupported implementation " + downloaderImplClassName + " of " + JarDownloader.class.getSimpleName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toCollection(ArrayList::new));
        return downloadedURLs.toArray(new URL[downloadedURLs.size()]);
    }

    private List<ScanResult> scanForProcessors(ClassLoader classLoader, URL[] downloadedUrls) throws Exception {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addClassLoader(classLoader).addScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()}).addUrls(downloadedUrls));
        Sets.SetView processors = Sets.intersection((Set)reflections.getTypesAnnotatedWith(Processor.class), (Set)reflections.getSubTypesOf(ProcessorBase.class));
        return processors.stream().map(processor -> {
            Processor processorInfo = processor.getAnnotation(Processor.class);
            ComponentMetadata metadata = ComponentMetadata.builder().type(ComponentType.PROCESSOR).namespace(processorInfo.namespace()).name(processorInfo.name()).version(processorInfo.version()).description(processorInfo.description()).cpu(processorInfo.cpu()).memory(processorInfo.memory()).processorType(processorInfo.processorType()).requiredProperties((List)ImmutableList.copyOf((Object[])processorInfo.requiredProperties())).optionalProperties((List)ImmutableList.copyOf((Object[])processorInfo.optionalProperties())).build();
            return ScanResult.builder().metadata(metadata).componentClass((Class<?>)processor).build();
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    private List<ScanResult> scanForSources(ClassLoader classLoader, URL[] downloadedUrls) throws Exception {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addClassLoader(classLoader).addScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner()}).addUrls(downloadedUrls));
        Sets.SetView sources = Sets.intersection((Set)reflections.getTypesAnnotatedWith(Source.class), (Set)reflections.getSubTypesOf(PipelineSource.class));
        return sources.stream().map(source -> {
            Source sourceInfo = source.getAnnotation(Source.class);
            ComponentMetadata metadata = ComponentMetadata.builder().type(ComponentType.SOURCE).namespace(sourceInfo.namespace()).name(sourceInfo.name()).version(sourceInfo.version()).description(sourceInfo.description()).cpu(sourceInfo.cpu()).memory(sourceInfo.memory()).requiredProperties((List)ImmutableList.copyOf((Object[])sourceInfo.requiredProperties())).optionalProperties((List)ImmutableList.copyOf((Object[])sourceInfo.optionalProperties())).build();
            return ScanResult.builder().metadata(metadata).componentClass((Class<?>)source).build();
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    public static class ScanResult {
        private ComponentMetadata metadata;
        private Class<?> componentClass;

        ScanResult(ComponentMetadata metadata, Class<?> componentClass) {
            this.metadata = metadata;
            this.componentClass = componentClass;
        }

        public static ScanResultBuilder builder() {
            return new ScanResultBuilder();
        }

        public ComponentMetadata getMetadata() {
            return this.metadata;
        }

        public Class<?> getComponentClass() {
            return this.componentClass;
        }

        public void setMetadata(ComponentMetadata metadata) {
            this.metadata = metadata;
        }

        public void setComponentClass(Class<?> componentClass) {
            this.componentClass = componentClass;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScanResult)) {
                return false;
            }
            ScanResult other = (ScanResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ComponentMetadata this$metadata = this.getMetadata();
            ComponentMetadata other$metadata = other.getMetadata();
            if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
                return false;
            }
            Class<?> this$componentClass = this.getComponentClass();
            Class<?> other$componentClass = other.getComponentClass();
            return !(this$componentClass == null ? other$componentClass != null : !this$componentClass.equals(other$componentClass));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ScanResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ComponentMetadata $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
            Class<?> $componentClass = this.getComponentClass();
            result = result * 59 + ($componentClass == null ? 43 : $componentClass.hashCode());
            return result;
        }

        public String toString() {
            return "JarScanner.ScanResult(metadata=" + this.getMetadata() + ", componentClass=" + this.getComponentClass() + ")";
        }

        public static class ScanResultBuilder {
            private ComponentMetadata metadata;
            private Class<?> componentClass;

            ScanResultBuilder() {
            }

            public ScanResultBuilder metadata(ComponentMetadata metadata) {
                this.metadata = metadata;
                return this;
            }

            public ScanResultBuilder componentClass(Class<?> componentClass) {
                this.componentClass = componentClass;
                return this;
            }

            public ScanResult build() {
                return new ScanResult(this.metadata, this.componentClass);
            }

            public String toString() {
                return "JarScanner.ScanResult.ScanResultBuilder(metadata=" + this.metadata + ", componentClass=" + this.componentClass + ")";
            }
        }
    }
}

